/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.events;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.HandlerList;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.events.PlayerEvent;
import protocolsupport.libs.org.apache.commons.lang3.Validate;

public class PlayerPropertiesResolveEvent
extends PlayerEvent {
    private final HashMap<String, ProfileProperty> properties = new HashMap();
    private static final HandlerList list = new HandlerList();

    public PlayerPropertiesResolveEvent(Connection connection, String username, Collection<ProfileProperty> properties) {
        super(connection, username);
        for (ProfileProperty property : properties) {
            this.addProperty(property);
        }
    }

    @Deprecated
    public PlayerPropertiesResolveEvent(InetSocketAddress address, String username, Collection<ProfileProperty> properties) {
        this(ProtocolSupportAPI.getConnection(address), username, properties);
    }

    public Map<String, ProfileProperty> getProperties() {
        return new HashMap<String, ProfileProperty>(this.properties);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public void addProperty(ProfileProperty property) {
        this.properties.put(property.getName(), property);
    }

    public HandlerList getHandlers() {
        return list;
    }

    public static HandlerList getHandlerList() {
        return list;
    }

    public static class ProfileProperty {
        private final String name;
        private final String value;
        private final String signature;

        public ProfileProperty(String name, String value, String signature) {
            Validate.notNull(name, "Name cannot be null", new Object[0]);
            Validate.notNull(value, "Value cannot be null", new Object[0]);
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        public ProfileProperty(String name, String value) {
            this(name, value, null);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean hasSignature() {
            return this.signature != null;
        }
    }
}

