/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.updater;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.messages.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater {
    private String version = "";
    private boolean updConfig = false;
    private Plugin plugin = Bukkit.getPluginManager().getPlugin("Legendchat");
    private boolean updLang = false;

    public Updater(String v) {
        this.version = v;
    }

    public Updater() {
    }

    public String CheckNewVersion() throws Exception {
        String v = "";
        URL url = new URL("https://api.curseforge.com/servermods/files?projectIds=74494");
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.addRequestProperty("User-Agent", "Legendchat (by PauloABR)");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (Exception e) {
            throw new Exception();
        }
        String response = reader.readLine();
        JSONArray array = (JSONArray)JSONValue.parse((String)response);
        if (array.size() <= 0) {
            return null;
        }
        JSONObject latest = (JSONObject)array.get(array.size() - 1);
        v = ((String)latest.get((Object)"name")).split("\\(")[1].split("\\)")[0].replace("V", "");
        boolean f = false;
        if (!this.version.equals(v)) {
            String[] v_obtained = v.split("\\.");
            String[] v_here = this.version.split("\\.");
            boolean draw = true;
            for (int i = 0; i < (v_obtained.length > v_here.length ? v_here.length : v_obtained.length); ++i) {
                int n_here;
                int n_obtained = Integer.parseInt(v_obtained[i]);
                if (n_obtained > (n_here = Integer.parseInt(v_here[i]))) {
                    f = true;
                    break;
                }
                if (n_obtained >= n_here) continue;
                draw = false;
                break;
            }
            if (draw && v_obtained.length > v_here.length) {
                f = true;
            }
        }
        String r = f ? v : null;
        return r;
    }

    public boolean updateConfig() {
        InputStream is = this.plugin.getResource("config_template.yml".replace('\\', '/'));
        YamlConfiguration c = YamlConfiguration.loadConfiguration((InputStream)is);
        for (String n : c.getConfigurationSection("").getKeys(true)) {
            if (this.has(n)) continue;
            this.set(n, c.get(n));
        }
        if (this.updConfig) {
            this.plugin.saveConfig();
        }
        return this.updConfig;
    }

    private boolean has(String s) {
        return this.plugin.getConfig().contains(s);
    }

    private void set(String s, Object obj) {
        this.plugin.getConfig().set(s, obj);
        this.updConfig = true;
    }

    public boolean updateAndLoadLanguage(String language) {
        File f = new File(this.plugin.getDataFolder(), "language" + File.separator + "language_" + language + ".yml");
        MessageManager m = Legendchat.getMessageManager();
        m.registerLanguageFile(f);
        m.loadMessages(f);
        InputStream is = null;
        is = this.plugin.getResource(("language" + File.separator + "language_" + language + ".yml").replace('\\', '/'));
        if (is == null) {
            is = this.plugin.getResource(("language" + File.separator + "language_en.yml").replace('\\', '/'));
        }
        YamlConfiguration c = YamlConfiguration.loadConfiguration((InputStream)is);
        for (String n : c.getConfigurationSection("").getKeys(false)) {
            if (m.hasMessage(n)) continue;
            this.addMessage(m, n, c.getString(n));
        }
        if (this.updLang) {
            m.loadMessages(f);
        }
        return this.updLang;
    }

    private void addMessage(MessageManager m, String name, String msg) {
        m.addMessageToFile(name, msg);
        this.updLang = true;
    }

    public boolean updateChannels() {
        boolean upd = false;
        for (File channel : new File(Bukkit.getPluginManager().getPlugin("Legendchat").getDataFolder(), "channels").listFiles()) {
            YamlConfiguration channel2 = YamlConfiguration.loadConfiguration((File)channel);
            if (!channel2.contains("needFocus")) {
                channel2.set("needFocus", (Object)false);
                upd = true;
            }
            try {
                channel2.save(channel);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return upd;
    }
}

