/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.delays;

import br.com.devpaulo.legendchat.channels.types.Channel;
import br.com.devpaulo.legendchat.delays.Delay;
import java.util.HashMap;

public class DelayManager {
    private final HashMap<String, Delay> delays = new HashMap();

    public void addPlayerDelay(String name, Channel c) {
        if (this.hasPlayerDelay(name = name.toLowerCase())) {
            this.getPlayerDelay(name).addDelay(c);
        } else {
            Delay d = new Delay(name);
            this.delays.put(name, d);
            d.addDelay(c);
        }
    }

    public Delay getPlayerDelay(String name) {
        if (this.hasPlayerDelay(name = name.toLowerCase())) {
            return this.delays.get(name);
        }
        return null;
    }

    public int getPlayerDelayFromChannel(String name, Channel c) {
        if (this.hasPlayerDelay(name = name.toLowerCase())) {
            return this.delays.get(name).getDelay(c);
        }
        return 0;
    }

    public void removePlayerDelay(String name) {
        if (!this.hasPlayerDelay(name = name.toLowerCase())) {
            return;
        }
        Delay d = this.getPlayerDelay(name);
        if (d.getDelaysSize() > 0) {
            for (Channel c : d.getDelayedChannels()) {
                d.removeDelay(c);
            }
        }
        this.delays.remove(name);
    }

    public boolean hasPlayerDelay(String name) {
        return this.delays.containsKey(name.toLowerCase());
    }
}

