/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.BungeecordChannel;
import br.com.devpaulo.legendchat.channels.types.PermanentChannel;
import br.com.devpaulo.legendchat.commands.Commands;
import br.com.devpaulo.legendchat.listeners.Listeners;
import br.com.devpaulo.legendchat.listeners.Listeners_old;
import br.com.devpaulo.legendchat.updater.Updater;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Main
extends JavaPlugin
implements PluginMessageListener {
    public static Permission perms = null;
    public static Economy econ = null;
    public static Chat chat = null;
    public static boolean block_econ = false;
    public static boolean block_perms = false;
    public static boolean block_chat = false;
    public static boolean bungeeActive = false;
    public static String language = "en";
    public static String need_update = null;

    public void onEnable() {
        File file;
        this.getLogger().log(Level.INFO, "Legendchat (V{0}) - Author: SubZero0", this.getDescription().getVersion());
        Legendchat.load(false);
        this.getServer().getPluginCommand("legendchat").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("channel").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("tell").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("reply").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("afk").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("ignore").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("tempchannel").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginCommand("mute").setExecutor((CommandExecutor)new Commands());
        if (this.getConfig().getBoolean("use_async_chat_event", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new Listeners(), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new Listeners_old(), (Plugin)this);
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "Legendchat");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "Legendchat", (PluginMessageListener)this);
        boolean check_update = true;
        if (this.getConfig().contains("check_for_updates") && !this.getConfig().getBoolean("check_for_updates")) {
            check_update = false;
        }
        if (check_update) {
            this.getLogger().info("Checking for updates...");
            try {
                Updater vup = new Updater(this.getDescription().getVersion());
                String vup_r = vup.CheckNewVersion();
                if (vup_r == null) {
                    this.getLogger().info("No updates found.");
                } else {
                    this.getLogger().log(Level.INFO, "New update avaible: V{0}!", vup_r);
                    this.getLogger().info("Download: http://dev.bukkit.org/bukkit-plugins/legendchat/");
                    need_update = vup_r;
                }
            }
            catch (Exception e) {
                this.getLogger().info("Error when checking for updates!");
            }
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                this.saveResource("config_template.yml", false);
                File file2 = new File(this.getDataFolder(), "config_template.yml");
                file2.renameTo(new File(this.getDataFolder(), "config.yml"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.reloadConfig();
        if (new Updater().updateConfig()) {
            this.getLogger().info("Configuration file updated!");
        }
        new File(this.getDataFolder(), "language").mkdir();
        for (File f : this.getDataFolder().listFiles()) {
            if (!f.getName().startsWith("language_")) continue;
            try {
                Files.move((File)new File(this.getDataFolder(), f.getName()), (File)new File(this.getDataFolder(), "language" + File.separator + f.getName()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (!new File(this.getDataFolder(), "language" + File.separator + "language_br.yml").exists()) {
                this.saveResource("language" + File.separator + "language_br.yml", false);
                this.getLogger().info("Saved language_br.yml");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!new File(this.getDataFolder(), "language" + File.separator + "language_en.yml").exists()) {
                this.saveResource("language" + File.separator + "language_en.yml", false);
                this.getLogger().info("Saved language_en.yml");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!new File(this.getDataFolder(), "language" + File.separator + "language_cn.yml").exists()) {
                this.saveResource("language" + File.separator + "language_cn.yml", false);
                this.getLogger().info("Saved language_cn.yml");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!new File(this.getDataFolder(), "temporary_channels.yml").exists()) {
                this.saveResource("temporary_channels.yml", false);
                this.getLogger().info("Saved temporary_channels.yml");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        File channels = new File(this.getDataFolder(), "channels");
        if (!channels.exists()) {
            channels.mkdir();
            Legendchat.getChannelManager().createPermanentChannel(new PermanentChannel("global", "g", "{default}", "GRAY", true, false, 0.0, true, 0, 0.0, true));
            Legendchat.getChannelManager().createPermanentChannel(new PermanentChannel("local", "l", "{default}", "YELLOW", true, false, 60.0, false, 0, 0.0, true));
            Legendchat.getChannelManager().createPermanentChannel(new BungeecordChannel("bungeecord", "b", "{bungeecord}", "LIGHTPURPLE", true, false, 0.0, false, 0, 0.0, true));
        }
        if (new Updater().updateChannels()) {
            this.getLogger().info("Channels file updated!");
        }
        Legendchat.getChannelManager().loadChannels();
        language = this.getConfig().getString("language").trim();
        if (new Updater().updateAndLoadLanguage(language)) {
            this.getLogger().info("Language file updated!");
        }
        if (!this.setupPermissions()) {
            this.getLogger().warning("Vault is not linked to any permissions plugin.");
            block_perms = true;
        } else {
            this.getLogger().info("Hooked to Vault (Permissions).");
        }
        if (!this.setupEconomy()) {
            this.getLogger().warning("Vault is not linked to any economy plugin.");
            block_econ = true;
        } else {
            this.getLogger().info("Hooked to Vault (Economy).");
        }
        if (!this.setupChat()) {
            this.getLogger().warning("Vault is not linked to any chat plugin.");
            block_chat = true;
        } else {
            this.getLogger().info("Hooked to Vault (Chat).");
        }
        if (this.getConfig().getBoolean("bungeecord.use", false) && Legendchat.getChannelManager().existsChannel(this.getConfig().getString("bungeecord.channel", "bungeecord"))) {
            bungeeActive = true;
        }
        Legendchat.load(true);
        for (Player p : this.getServer().getOnlinePlayers()) {
            Legendchat.getPlayerManager().setPlayerFocusedChannel(p, Legendchat.getDefaultChannel(), false);
        }
    }

    private boolean setupPermissions() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            return false;
        }
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    private boolean setupChat() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (rsp == null) {
            return false;
        }
        chat = (Chat)rsp.getProvider();
        return chat != null;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public void onDisable() {
        this.getLogger().info("Disabling Legendchat - Author: SubZero0");
        Legendchat.getLogManager().saveLog();
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (Legendchat.isBungeecordActive()) {
            String[] pairs;
            if (!channel.equals("Legendchat")) {
                return;
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
            String raw_tags = "";
            String msg = "";
            try {
                raw_tags = in.readUTF();
                msg = in.readUTF();
            }
            catch (IOException e) {
                // empty catch block
            }
            HashMap<String, String> tags = new HashMap<String, String>();
            raw_tags = raw_tags.substring(1, raw_tags.length() - 1);
            for (String separated_pairs : pairs = raw_tags.split(",")) {
                String[] pair = separated_pairs.split("=");
                tags.put(pair[0].replace(" ", ""), pair.length == 1 ? "" : pair[1]);
            }
            this.getServer().getLogger().log(Level.INFO, "[Legendchat] Incoming message from server {0}", tags.get("server"));
            BungeecordChannel c = Legendchat.getBungeecordChannel();
            if (c != null) {
                c.sendBungeecordMessage(tags, msg);
            }
        }
    }
}

