/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.listeners;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class SCEntityListener
implements Listener {
    private SimpleClans plugin = SimpleClans.getInstance();

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player victim = (Player)event.getEntity();
            if (this.plugin.getSettingsManager().isBlacklistedWorld(victim.getLocation().getWorld().getName())) {
                return;
            }
            Player attacker = null;
            EntityDamageEvent lastDamageCause = victim.getLastDamageCause();
            if (lastDamageCause instanceof EntityDamageByEntityEvent) {
                Arrow arrow;
                EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)lastDamageCause;
                if (entityEvent.getDamager() instanceof Player) {
                    attacker = (Player)entityEvent.getDamager();
                } else if (entityEvent.getDamager() instanceof Arrow && (arrow = (Arrow)entityEvent.getDamager()).getShooter() instanceof Player) {
                    attacker = (Player)arrow.getShooter();
                }
            }
            if (attacker != null && victim != null) {
                ClanPlayer vcp;
                ClanPlayer acp;
                if (SimpleClans.getInstance().hasUUID()) {
                    acp = this.plugin.getClanManager().getCreateClanPlayer(attacker.getUniqueId());
                    vcp = this.plugin.getClanManager().getCreateClanPlayer(victim.getUniqueId());
                } else {
                    acp = this.plugin.getClanManager().getCreateClanPlayer(attacker.getName());
                    vcp = this.plugin.getClanManager().getCreateClanPlayer(victim.getName());
                }
                double reward = 0.0;
                double multipier = this.plugin.getSettingsManager().getKDRMultipliesPerKill();
                float kdr = acp.getKDR();
                if (vcp.getClan() == null || acp.getClan() == null || !vcp.getClan().isVerified() || !acp.getClan().isVerified()) {
                    acp.addCivilianKill();
                    this.plugin.getStorageManager().insertKill(attacker, acp.getTag(), victim, "", "c");
                } else if (acp.getClan().isRival(vcp.getTag())) {
                    reward = acp.getClan().isWarring(vcp.getClan()) ? (double)kdr * multipier * 4.0 : (double)kdr * multipier * 2.0;
                    acp.addRivalKill();
                    this.plugin.getStorageManager().insertKill(attacker, acp.getTag(), victim, vcp.getTag(), "r");
                } else if (acp.getClan().isAlly(vcp.getTag())) {
                    reward = (double)kdr * multipier * -1.0;
                } else {
                    reward = (double)kdr * multipier;
                    acp.addNeutralKill();
                    this.plugin.getStorageManager().insertKill(attacker, acp.getTag(), victim, vcp.getTag(), "n");
                }
                if (reward != 0.0 && this.plugin.getSettingsManager().isMoneyPerKill()) {
                    for (ClanPlayer cp : acp.getClan().getOnlineMembers()) {
                        double money = (double)Math.round(reward / (double)acp.getClan().getOnlineMembers().size() * 100.0) / 100.0;
                        cp.toPlayer().sendMessage(ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("player.got.money"), money, victim.getName(), Float.valueOf(kdr)));
                        this.plugin.getPermissionsManager().playerGrantMoney(cp.getName(), money);
                    }
                }
                vcp.addDeath();
                this.plugin.getStorageManager().updateClanPlayerAsync(vcp);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getSettingsManager().isTamableMobsSharing() && event.getRightClicked() instanceof Tameable) {
            Entity entity = event.getRightClicked();
            Player player = event.getPlayer();
            ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
            Tameable tamed = (Tameable)entity;
            if (tamed.isTamed()) {
                if (entity instanceof Wolf && !((Wolf)entity).isSitting()) {
                    return;
                }
                if (cp.getClan().isMember((Player)tamed.getOwner())) {
                    tamed.setOwner((AnimalTamer)player);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        if (this.plugin.getSettingsManager().isTamableMobsSharing() && event.getEntity() instanceof Tameable && event.getTarget() instanceof Player) {
            ClanPlayer cp = this.plugin.getClanManager().getClanPlayer((Player)event.getTarget());
            Tameable wolf = (Tameable)event.getEntity();
            if (wolf.isTamed() && cp.getClan().isMember((Player)wolf.getOwner())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player attacker = null;
        Player victim = null;
        if (event instanceof EntityDamageByEntityEvent) {
            Arrow arrow;
            EntityDamageByEntityEvent sub = (EntityDamageByEntityEvent)event;
            if (sub.getEntity() instanceof Player && sub.getDamager() instanceof Player) {
                attacker = (Player)sub.getDamager();
                victim = (Player)sub.getEntity();
            }
            if (this.plugin.getSettingsManager().isTamableMobsSharing() && sub.getEntity() instanceof Wolf && sub.getDamager() instanceof Player) {
                attacker = (Player)sub.getDamager();
                Wolf wolf = (Wolf)sub.getEntity();
                ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(attacker);
                if (wolf.isTamed() && cp.getClan().isMember((Player)wolf.getOwner())) {
                    wolf.setAngry(false);
                }
            }
            if (sub.getEntity() instanceof Player && sub.getDamager() instanceof Arrow && (arrow = (Arrow)sub.getDamager()).getShooter() instanceof Player) {
                attacker = (Player)arrow.getShooter();
                victim = (Player)sub.getEntity();
            }
        }
        if (victim != null && this.plugin.getSettingsManager().isBlacklistedWorld(victim.getLocation().getWorld().getName())) {
            return;
        }
        if (attacker != null && victim != null) {
            Clan aclan;
            ClanPlayer acp = this.plugin.getClanManager().getClanPlayer(attacker);
            ClanPlayer vcp = this.plugin.getClanManager().getClanPlayer(victim);
            Clan vclan = vcp == null ? null : vcp.getClan();
            Clan clan = aclan = acp == null ? null : acp.getClan();
            if (this.plugin.getSettingsManager().isPvpOnlywhileInWar()) {
                if (aclan == null || vclan == null) {
                    event.setCancelled(true);
                    return;
                }
                if (this.plugin.getPermissionsManager().has(victim, "simpleclans.mod.nopvpinwar") && attacker != null && victim != null) {
                    event.setCancelled(true);
                    return;
                }
                if (!aclan.isWarring(vclan)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (vclan != null) {
                if (aclan != null) {
                    if (vcp.isFriendlyFire()) {
                        return;
                    }
                    if (vclan.isFriendlyFire()) {
                        return;
                    }
                    if (vclan.equals(aclan)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (vclan.isAlly(aclan.getTag())) {
                        event.setCancelled(true);
                    }
                } else if (this.plugin.getSettingsManager().getSafeCivilians()) {
                    event.setCancelled(true);
                }
            } else if (this.plugin.getSettingsManager().getSafeCivilians()) {
                event.setCancelled(true);
            }
        }
    }
}

