/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.ClanRequest;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.VoteResult;

public final class Request {
    private List<ClanPlayer> acceptors = new ArrayList<ClanPlayer>();
    private Clan clan;
    private String msg;
    private String target;
    private ClanRequest type;
    private ClanPlayer requester;
    private int askCount;

    public Request(SimpleClans plugin, ClanRequest type, List<ClanPlayer> acceptors, ClanPlayer requester, String target, Clan clan, String msg) {
        this.type = type;
        this.target = target;
        this.clan = clan;
        this.msg = msg;
        if (acceptors != null) {
            this.acceptors = acceptors;
        }
        this.requester = requester;
        this.cleanVotes();
    }

    public ClanRequest getType() {
        return this.type;
    }

    public void setType(ClanRequest type) {
        this.type = type;
    }

    public List<ClanPlayer> getAcceptors() {
        return Collections.unmodifiableList(this.acceptors);
    }

    public void setAcceptors(List<ClanPlayer> acceptors) {
        this.acceptors = acceptors;
    }

    public Clan getClan() {
        return this.clan;
    }

    public void setClan(Clan clan) {
        this.clan = clan;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void vote(String playerNAme, VoteResult vote) {
        for (ClanPlayer cp : this.acceptors) {
            if (!cp.getName().equalsIgnoreCase(playerNAme)) continue;
            cp.setVote(vote);
        }
    }

    public boolean votingFinished() {
        for (ClanPlayer cp : this.acceptors) {
            if (cp.getVote() != null) continue;
            return false;
        }
        return true;
    }

    public List<String> getDenies() {
        ArrayList<String> out = new ArrayList<String>();
        for (ClanPlayer cp : this.acceptors) {
            if (cp.getVote() == null || !cp.getVote().equals((Object)VoteResult.DENY)) continue;
            out.add(cp.getName());
        }
        return out;
    }

    public List<String> getAccepts() {
        ArrayList<String> out = new ArrayList<String>();
        for (ClanPlayer cp : this.acceptors) {
            if (cp.getVote() == null || !cp.getVote().equals((Object)VoteResult.ACCEPT)) continue;
            out.add(cp.getName());
        }
        return out;
    }

    public void cleanVotes() {
        for (ClanPlayer cp : this.acceptors) {
            cp.setVote(null);
        }
    }

    public ClanPlayer getRequester() {
        return this.requester;
    }

    public void setRequester(ClanPlayer requester) {
        this.requester = requester;
    }

    public void incrementAskCount() {
        ++this.askCount;
    }

    public boolean reachedRequestLimit() {
        return this.askCount > SimpleClans.getInstance().getSettingsManager().getMaxAsksPerRequest();
    }
}

