/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.misc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LockedReference<T> {
    private final Lock lock = new ReentrantLock();
    private final Supplier<T> supplier;
    private final Consumer<T> invalidator;
    private final long expiryTime;
    private T object;
    private long timeClaimed;

    public LockedReference(Supplier<T> supplier, long expiryTime, TimeUnit unit, Consumer<T> invalidator) {
        this.supplier = supplier;
        this.invalidator = invalidator;
        this.expiryTime = unit.toMillis(expiryTime);
    }

    public T access() {
        this.lock.lock();
        if (this.timeClaimed + this.expiryTime < System.currentTimeMillis()) {
            if (this.object != null && this.invalidator != null) {
                this.invalidator.accept(this.object);
            }
            this.object = this.supplier.get();
            this.timeClaimed = System.currentTimeMillis();
        }
        return this.object;
    }

    public void finish() {
        this.lock.unlock();
    }

    public void invalidateNow() {
        this.invalidator.accept(this.object);
        this.object = null;
        this.timeClaimed = 0L;
    }
}

