/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.listeners;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.data.DataManager;
import com.lenis0012.bukkit.marriage2.internal.data.MarriagePlayer;
import com.lenis0012.bukkit.marriage2.misc.ListQuery;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DatabaseListener
implements Listener {
    private final Cache<UUID, MarriagePlayer> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final MarriageCore core;

    public DatabaseListener(MarriageCore core) {
        this.core = core;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            MarriagePlayer player = this.core.getDataManager().loadPlayer(event.getUniqueId());
            player.setLastName(event.getName());
            this.cache.put((Object)event.getUniqueId(), (Object)player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID userId = player.getUniqueId();
        MarriagePlayer mplayer = (MarriagePlayer)this.cache.getIfPresent((Object)userId);
        if (mplayer != null) {
            this.loadPartnerName(mplayer, player);
            this.core.setMPlayer(userId, mplayer);
            return;
        }
        this.core.getLogger().log(Level.WARNING, "Player " + event.getPlayer().getName() + " was not in cache");
        this.core.getLogger().log(Level.INFO, "If this message shows often, report to dev");
        mplayer = this.core.getDataManager().loadPlayer(userId);
        mplayer.setLastName(player.getName());
        this.loadPartnerName(mplayer, player);
        this.core.setMPlayer(userId, mplayer);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.core.unloadPlayer(player.getUniqueId());
        if (player.hasMetadata("marriedTo")) {
            player.removeMetadata("marriedTo", (Plugin)this.core.getPlugin());
        }
    }

    private void loadPartnerName(final MPlayer mplayer, final Player player) {
        if (!mplayer.isMarried()) {
            return;
        }
        DataManager.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                final String partner = ListQuery.getName(DatabaseListener.this.core.getDataManager(), mplayer.getMarriage().getOtherPlayer(player.getUniqueId()));
                if (partner == null) {
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)DatabaseListener.this.core.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        player.setMetadata("marriedTo", (MetadataValue)new FixedMetadataValue((Plugin)DatabaseListener.this.core.getPlugin(), (Object)partner));
                    }
                });
            }
        });
    }
}

