/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal;

import com.google.common.collect.Lists;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.Register;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.PluginHolder;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.configuration.ConfigurationModule;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.packets.PacketModule;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MarriagePlugin
extends PluginHolder {
    private static MarriageCore core;
    private final List<Method>[] methods = new List[Register.Type.values().length];

    public static Marriage getCore() {
        return core;
    }

    public MarriagePlugin() {
        super(PacketModule.class, ConfigurationModule.class);
        core = new MarriageCore(this);
        for (int i = 0; i < this.methods.length; ++i) {
            this.methods[i] = Lists.newArrayList();
        }
        this.scanMethods(core.getClass());
    }

    private void scanMethods(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            Register register = method.getAnnotation(Register.class);
            if (register == null) continue;
            this.methods[register.type().ordinal()].add(method);
        }
        this.scanMethods(clazz.getSuperclass());
    }

    protected File getPluginFile() {
        return this.getFile();
    }

    public void onLoad() {
        this.executeMethods(Register.Type.LOAD);
    }

    @Override
    public void enable() {
        this.executeMethods(Register.Type.ENABLE);
    }

    @Override
    public void disable() {
        this.executeMethods(Register.Type.DISABLE);
    }

    private void executeMethods(Register.Type type) {
        ArrayList list = Lists.newArrayList(this.methods[type.ordinal()]);
        while (!list.isEmpty()) {
            Method method = null;
            int lowestPriority = Integer.MAX_VALUE;
            for (Method m : list) {
                Register register = m.getAnnotation(Register.class);
                if (register.priority() >= lowestPriority) continue;
                method = m;
                lowestPriority = register.priority();
            }
            if (method != null) {
                list.remove(method);
                Register register = method.getAnnotation(Register.class);
                this.getLogger().log(Level.INFO, "Loading " + register.name() + "...");
                try {
                    method.invoke((Object)core, new Object[0]);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to load " + register.name(), e);
                }
                continue;
            }
            list.clear();
        }
        this.getLogger().log(Level.INFO, type.getCompletionMessage());
    }
}

