/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.config;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public enum Permissions {
    ALL("marry.*", PermissionDefault.FALSE, -1),
    ADMIN("marry.admin", PermissionDefault.OP, 0),
    DEFAULT("marry.default", PermissionDefault.OP, 0),
    UPDATE("marry.update", PermissionDefault.FALSE, 1),
    CHAT_SPY("marry.chatspy", PermissionDefault.FALSE, 1),
    MARRY("marry.marry"),
    LIST("marry.list"),
    TELEPORT("marry.tp"),
    HOME("marry.home"),
    SET_HOME("marry.sethome"),
    GIFT("marry.gift"),
    CHAT("marry.chat"),
    SEEN("marry.seen");

    private final String node;
    private final PermissionDefault defaultSetting;
    private final int parent;
    private Permission permission;

    private Permissions(String node) {
        this(node, PermissionDefault.FALSE);
    }

    private Permissions(String node, PermissionDefault defaultSetting) {
        this(node, defaultSetting, 2);
    }

    private Permissions(String node, PermissionDefault defaultSetting, int parent) {
        this.node = node;
        this.defaultSetting = defaultSetting;
        this.parent = parent;
        this.permission = new Permission(node, null, defaultSetting);
        Bukkit.getPluginManager().addPermission(this.permission);
    }

    public boolean has(CommandSender sender) {
        return sender.hasPermission(this.permission);
    }

    public static Permissions getByNode(String node) {
        for (Permissions permission : Permissions.values()) {
            if (!permission.node.equalsIgnoreCase(node)) continue;
            return permission;
        }
        return null;
    }

    public static void setupChildRelations() {
        for (Permissions perm : Permissions.values()) {
            if (perm.parent < 0) continue;
            perm.permission.addParent(Permissions.values()[perm.parent].permission, true);
        }
    }

    public static void unloadAll() {
        for (Permissions perm : Permissions.values()) {
            Bukkit.getPluginManager().removePermission(perm.permission);
        }
    }
}

