/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.commands;

import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.config.Permissions;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.data.DataManager;
import com.lenis0012.bukkit.marriage2.internal.data.Driver;
import org.bukkit.Bukkit;

public class CommandMigrate
extends Command {
    public CommandMigrate(Marriage marriage) {
        super(marriage, "migrate", new String[0]);
        this.setMinArgs(2);
        this.setHidden(true);
        this.setPermission(Permissions.ADMIN);
    }

    @Override
    public void execute() {
        Driver driver;
        MarriageCore core = (MarriageCore)this.marriage;
        final DataManager newDatabase = core.getDataManager();
        if (this.getArg(0).equalsIgnoreCase("sqlite") && this.getArg(1).equalsIgnoreCase("mysql")) {
            driver = Driver.SQLITE;
        } else if (this.getArg(0).equalsIgnoreCase("mysql") && this.getArg(1).equalsIgnoreCase("sqlite")) {
            driver = Driver.MYSQL;
        } else {
            this.reply("&cUsage: /marry migrate <old db> <new db>", new Object[0]);
            return;
        }
        final boolean fastMode = this.getArgLength() <= 2 || !this.getArg(2).equalsIgnoreCase("false");
        final DataManager oldDatabase = new DataManager(core, driver);
        this.reply("&aStarting migration process (might take a while)", new Object[0]);
        Bukkit.getScheduler().runTaskAsynchronously(this.marriage.getPlugin(), new Runnable(){

            @Override
            public void run() {
                boolean success = oldDatabase.migrateTo(newDatabase, !fastMode);
                oldDatabase.close();
                CommandMigrate.this.reply(success ? "&aSuccessfully migrated database!" : "&cSomething went wrong while migrating, check log.", new Object[0]);
            }
        });
    }
}

