/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.commands;

import com.google.common.collect.Lists;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.config.Message;
import com.lenis0012.bukkit.marriage2.config.Permissions;
import com.lenis0012.bukkit.marriage2.config.Settings;
import com.lenis0012.bukkit.marriage2.internal.Dependencies;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.configuration.mapping.ConfigOption;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class Command {
    protected final Marriage marriage;
    private final String[] aliases;
    private String description = "No description available";
    private String usage = "";
    private int minArgs = 0;
    private Permissions permission = null;
    private boolean allowConsole = false;
    private boolean hidden = false;
    private double executionFee = 0.0;
    protected CommandSender sender;
    protected Player player;
    private String[] args;

    public Command(Marriage marriage, String command, String ... aliases) {
        this.marriage = marriage;
        this.aliases = Lists.asList((Object)command, (Object[])aliases).toArray(new String[0]);
        if (aliases.length > 0) {
            this.permission = Permissions.getByNode("marry." + aliases[0]);
        }
    }

    public abstract void execute();

    public void prepare(CommandSender sender, String[] args) {
        this.sender = sender;
        this.player = sender instanceof Player ? (Player)sender : null;
        this.args = args;
    }

    protected String getArg(int index) {
        return this.args[index + 1];
    }

    protected int getArgAsInt(int index) {
        return this.getArgAsInt(index, 0);
    }

    protected Player getArgAsPlayer(int index) {
        String name = this.getArg(index);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return player;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().toLowerCase().contains(name.toLowerCase())) continue;
            return player;
        }
        return null;
    }

    protected int getArgLength() {
        return this.args.length - 1;
    }

    protected int getArgAsInt(int index, int def) {
        try {
            return Integer.parseInt(this.getArg(index));
        }
        catch (Exception e) {
            return def;
        }
    }

    protected void reply(Message message, Object ... args) {
        this.reply(this.sender, message, args);
    }

    protected void reply(String message, Object ... args) {
        this.reply(this.sender, message, args);
    }

    protected void reply(CommandSender sender, Message message, Object ... args) {
        this.reply(sender, message.toString(), args);
    }

    protected void reply(CommandSender sender, String message, Object ... args) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, args));
        sender.sendMessage(message);
    }

    protected void broadcast(Message message, Object ... args) {
        this.broadcast(message.toString(), args);
    }

    protected void broadcast(String message, Object ... args) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, args));
        Bukkit.broadcastMessage((String)message);
    }

    public Permissions getPermission() {
        return this.permission;
    }

    public void setPermission(Permissions permission) {
        this.permission = permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public boolean isAllowConsole() {
        return this.allowConsole;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setUsage(String usage) {
        this.usage = usage;
    }

    protected void setMinArgs(int minArgs) {
        this.minArgs = minArgs;
    }

    protected void setAllowConsole(boolean allowConsole) {
        this.allowConsole = allowConsole;
    }

    protected boolean isHidden() {
        return this.hidden;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void setExecutionFee(ConfigOption<Double> setting) {
        if (!Settings.ECONOMY_ENABLED.value().booleanValue() || !Settings.ECONOMY_SHOW_PRICE.value().booleanValue()) {
            return;
        }
        Dependencies dependencies = this.marriage.dependencies();
        if (!dependencies.isEconomyEnabled()) {
            return;
        }
        this.executionFee = setting.value();
    }

    protected double getExecutionFee() {
        return this.executionFee;
    }

    protected boolean hasFee() {
        if (this.executionFee <= 0.0 || this.player == null) {
            return true;
        }
        return this.marriage.dependencies().getEconomyService().has((OfflinePlayer)this.player, this.executionFee);
    }

    protected boolean payFee() {
        if (this.executionFee <= 0.0 || this.player == null) {
            return true;
        }
        if (this.marriage.dependencies().getEconomyService().has((OfflinePlayer)this.player, this.executionFee)) {
            EconomyResponse response = this.marriage.dependencies().getEconomyService().withdrawPlayer((OfflinePlayer)this.player, this.executionFee);
            this.reply(Message.PAID_FEE, this.marriage.dependencies().getEconomyService().format(this.executionFee));
            return response.transactionSuccess();
        }
        this.reply(Message.INSUFFICIENT_MONEY, this.marriage.dependencies().getEconomyService().format(this.executionFee));
        return false;
    }
}

