/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.injector.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.util.Map;
import protocolsupport.zplatform.impl.spigot.injector.network.SpigotServerConnectionChannel;

public class SpigotNettyServerChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final ServerConnectionChannelPlacer serverConnectionChannelPlacer = new ServerConnectionChannelPlacer();

    public void channelRead(ChannelHandlerContext ctx, Object o) throws Exception {
        Channel channel = (Channel)o;
        channel.pipeline().addFirst(new ChannelHandler[]{serverConnectionChannelPlacer});
        super.channelRead(ctx, o);
    }

    private static class ServerConnectionChannelPlacer
    extends ChannelInitializer<Channel> {
        private static final SpigotServerConnectionChannel serverConnectionChannel = new SpigotServerConnectionChannel();

        private ServerConnectionChannelPlacer() {
        }

        protected void initChannel(Channel channel) throws Exception {
            String nativeServerConnection = ServerConnectionChannelPlacer.findNativeServerConnectionChannelHandlerName(channel.pipeline());
            if (nativeServerConnection != null) {
                channel.pipeline().addAfter(nativeServerConnection, "ps_server_connection", (ChannelHandler)serverConnectionChannel);
            } else {
                channel.pipeline().addLast(new ChannelHandler[]{serverConnectionChannel});
            }
        }

        private static String findNativeServerConnectionChannelHandlerName(ChannelPipeline pipeline) {
            for (Map.Entry entry : pipeline) {
                if (!((ChannelHandler)entry.getValue()).getClass().getName().equals("net.minecraft.server.v1_10_R1.ServerConnection$4")) continue;
                return (String)entry.getKey();
            }
            return null;
        }
    }
}

