/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.utils.chat;

import java.lang.reflect.Type;
import protocolsupport.api.chat.modifiers.ClickAction;
import protocolsupport.libs.com.google.gson.JsonDeserializationContext;
import protocolsupport.libs.com.google.gson.JsonDeserializer;
import protocolsupport.libs.com.google.gson.JsonElement;
import protocolsupport.libs.com.google.gson.JsonObject;
import protocolsupport.libs.com.google.gson.JsonParseException;
import protocolsupport.libs.com.google.gson.JsonSerializationContext;
import protocolsupport.libs.com.google.gson.JsonSerializer;

public class ClickActionSerializer
implements JsonDeserializer<ClickAction>,
JsonSerializer<ClickAction> {
    @Override
    public ClickAction deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject jsonobject = element.getAsJsonObject();
        if (!jsonobject.has("clickEvent")) {
            return null;
        }
        JsonObject clickObject = jsonobject.getAsJsonObject("clickEvent");
        ClickAction.Type atype = ClickAction.Type.valueOf(clickObject.getAsJsonPrimitive("action").getAsString().toUpperCase());
        return new ClickAction(atype, clickObject.getAsJsonPrimitive("value").getAsString());
    }

    @Override
    public JsonElement serialize(ClickAction action, Type type, JsonSerializationContext ctx) {
        JsonObject object = new JsonObject();
        object.addProperty("action", action.getType().toString().toLowerCase());
        object.addProperty("value", action.getValue());
        return object;
    }
}

