/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.datawatcher;

import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.libs.gnu.trove.iterator.TIntObjectIterator;
import protocolsupport.libs.gnu.trove.map.TIntObjectMap;
import protocolsupport.libs.gnu.trove.map.hash.TIntObjectHashMap;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.protocol.utils.datawatcher.DataWatcherObject;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectBlockState;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectBoolean;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectByte;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectChat;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectDirection;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectFloat;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectItemStack;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectOptionalPosition;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectOptionalUUID;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectPosition;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectString;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectVarInt;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectVector3f;

public class DataWatcherDeserializer {
    private static final Constructor<? extends DataWatcherObject<?>>[] registry = new Constructor[256];

    private static void register(Class<? extends DataWatcherObject<?>> clazz) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<DataWatcherObject<?>> constr = clazz.getConstructor(new Class[0]);
        DataWatcherDeserializer.registry[constr.newInstance((Object[])new Object[0]).getTypeId((ProtocolVersion)ProtocolVersion.getLatest())] = constr;
    }

    public static TIntObjectMap<DataWatcherObject<?>> decodeData(ProtocolSupportPacketDataSerializer serializer) {
        short key;
        TIntObjectHashMap map = new TIntObjectHashMap(10, 0.5f, -1);
        while ((key = serializer.readUnsignedByte()) != 255) {
            short type = serializer.readUnsignedByte();
            try {
                DataWatcherObject<?> object = registry[type].newInstance(new Object[0]);
                object.readFromStream(serializer);
                map.put(key, object);
            }
            catch (Exception e) {
                throw new DecoderException("Unable to decode datawatcher object", (Throwable)e);
            }
        }
        return map;
    }

    public static void encodeData(TIntObjectMap<DataWatcherObject<?>> objects, ProtocolSupportPacketDataSerializer serializer) {
        if (!objects.isEmpty()) {
            TIntObjectIterator<DataWatcherObject<?>> iterator = objects.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                DataWatcherObject<?> object = iterator.value();
                serializer.writeByte(iterator.key());
                serializer.writeByte(object.getTypeId(serializer.getVersion()));
                object.writeToStream(serializer);
            }
        } else {
            serializer.writeByte(31);
            serializer.writeByte(0);
            serializer.writeByte(0);
        }
        serializer.writeByte(255);
    }

    static {
        try {
            DataWatcherDeserializer.register(DataWatcherObjectByte.class);
            DataWatcherDeserializer.register(DataWatcherObjectVarInt.class);
            DataWatcherDeserializer.register(DataWatcherObjectFloat.class);
            DataWatcherDeserializer.register(DataWatcherObjectString.class);
            DataWatcherDeserializer.register(DataWatcherObjectChat.class);
            DataWatcherDeserializer.register(DataWatcherObjectItemStack.class);
            DataWatcherDeserializer.register(DataWatcherObjectBoolean.class);
            DataWatcherDeserializer.register(DataWatcherObjectVector3f.class);
            DataWatcherDeserializer.register(DataWatcherObjectPosition.class);
            DataWatcherDeserializer.register(DataWatcherObjectOptionalPosition.class);
            DataWatcherDeserializer.register(DataWatcherObjectDirection.class);
            DataWatcherDeserializer.register(DataWatcherObjectOptionalUUID.class);
            DataWatcherDeserializer.register(DataWatcherObjectBlockState.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in datawatcher init", e);
        }
    }
}

