/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.tileentity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.legacyremapper.LegacyEntityType;
import protocolsupport.protocol.typeremapper.id.RemappingTable;
import protocolsupport.protocol.typeremapper.itemstack.ItemStackRemapper;
import protocolsupport.protocol.typeremapper.tileentity.TileEntitySpecificRemapper;
import protocolsupport.protocol.typeremapper.tileentity.TileEntityUpdateType;
import protocolsupport.protocol.utils.data.ItemData;
import protocolsupport.protocol.utils.types.Position;
import protocolsupport.utils.ProtocolVersionsHelper;
import protocolsupport.utils.Utils;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class TileNBTRemapper {
    private static final String tileEntityTypeKey = "id";
    private static final HashMap<String, String> newToOldType = new HashMap();
    private static final EnumMap<TileEntityUpdateType, EnumMap<ProtocolVersion, List<TileEntitySpecificRemapper>>> registry;

    private static void register(TileEntityUpdateType type, TileEntitySpecificRemapper transformer, ProtocolVersion ... versions) {
        EnumMap map = Utils.getOrCreateDefault(registry, type, new EnumMap(ProtocolVersion.class));
        for (ProtocolVersion version : versions) {
            ((List)Utils.getOrCreateDefault(map, version, new ArrayList())).add(transformer);
        }
    }

    public static String getTileType(NBTTagCompoundWrapper tag) {
        return tag.getString(tileEntityTypeKey);
    }

    public static Position getPosition(NBTTagCompoundWrapper tag) {
        return new Position(tag.getNumber("x"), tag.getNumber("y"), tag.getNumber("z"));
    }

    public static String[] getSignLines(NBTTagCompoundWrapper tag) {
        String[] lines = new String[4];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = tag.getString("Text" + (i + 1));
        }
        return lines;
    }

    public static NBTTagCompoundWrapper remap(ProtocolVersion version, NBTTagCompoundWrapper compound) {
        List<TileEntitySpecificRemapper> transformers;
        EnumMap<ProtocolVersion, List<TileEntitySpecificRemapper>> map = registry.get((Object)TileEntityUpdateType.fromType(TileNBTRemapper.getTileType(compound)));
        if (map != null && (transformers = map.get((Object)version)) != null) {
            for (TileEntitySpecificRemapper transformer : transformers) {
                compound = transformer.remap(version, compound);
            }
            return compound;
        }
        return compound;
    }

    static {
        newToOldType.put("minecraft:mob_spawner", "MobSpawner");
        newToOldType.put("minecraft:command_block", "Control");
        newToOldType.put("minecraft:beacon", "Beacon");
        newToOldType.put("minecraft:skull", "Skull");
        newToOldType.put("minecraft:flower_pot", "FlowerPot");
        newToOldType.put("minecraft:banner", "Banner");
        newToOldType.put("minecraft:structure_block", "Structure");
        newToOldType.put("minecraft:end_gateway", "Airportal");
        newToOldType.put("minecraft:sign", "Sign");
        registry = new EnumMap(TileEntityUpdateType.class);
        for (TileEntityUpdateType type : TileEntityUpdateType.values()) {
            TileNBTRemapper.register(type, (version, input) -> {
                input.setString(tileEntityTypeKey, newToOldType.getOrDefault(input.getString(tileEntityTypeKey), "Unknown"));
                return input;
            }, ProtocolVersionsHelper.BEFORE_1_11);
        }
        TileNBTRemapper.register(TileEntityUpdateType.MOB_SPAWNER, (version, input) -> {
            if (!input.hasKeyOfType("SpawnData", 10)) {
                NBTTagCompoundWrapper spawndata = ServerPlatform.get().getWrapperFactory().createEmptyNBTCompound();
                spawndata.setString(tileEntityTypeKey, "minecraft:pig");
                input.setCompound("SpawnData", spawndata);
            }
            return input;
        }, ProtocolVersionsHelper.ALL);
        TileNBTRemapper.register(TileEntityUpdateType.MOB_SPAWNER, (version, input) -> {
            String mobname;
            NBTTagCompoundWrapper spawndata = input.getCompound("SpawnData");
            if (!spawndata.isNull() && !(mobname = spawndata.getString(tileEntityTypeKey)).isEmpty()) {
                spawndata.setString(tileEntityTypeKey, LegacyEntityType.getLegacyName(mobname));
            }
            return input;
        }, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_9, ProtocolVersion.MINECRAFT_1_10));
        TileNBTRemapper.register(TileEntityUpdateType.MOB_SPAWNER, (version, input) -> {
            String mobname;
            NBTTagCompoundWrapper spawndata = input.getCompound("SpawnData");
            input.remove("SpawnPotentials");
            input.remove("SpawnData");
            if (!spawndata.isNull() && !(mobname = spawndata.getString(tileEntityTypeKey)).isEmpty()) {
                input.setString("EntityId", LegacyEntityType.getLegacyName(mobname));
            }
            return input;
        }, ProtocolVersionsHelper.BEFORE_1_9);
        TileNBTRemapper.register(TileEntityUpdateType.SKULL, (version, input) -> {
            if (input.getNumber("SkullType") == 5) {
                input.setByte("SkullType", 3);
                input.setCompound("Owner", ItemStackRemapper.createDragonHeadSkullTag());
            }
            return input;
        }, ProtocolVersion.getAllBefore(ProtocolVersion.MINECRAFT_1_8));
        TileNBTRemapper.register(TileEntityUpdateType.SKULL, (version, input) -> {
            ItemStackRemapper.remapSkull(input);
            return input;
        }, ProtocolVersion.getAllBefore(ProtocolVersion.MINECRAFT_1_7_5));
        TileNBTRemapper.register(TileEntityUpdateType.FLOWER_POT, (version, input) -> {
            Integer id = ItemData.getIdByName(input.getString("Item"));
            if (id != null) {
                input.setInt("Item", ((RemappingTable.ArrayBasedIdRemappingTable)ItemStackRemapper.ITEM_ID_REMAPPING_REGISTRY.getTable(version)).getRemap(id));
            }
            return input;
        }, ProtocolVersionsHelper.BEFORE_1_8);
    }
}

