/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.version;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.packet.middle.ClientBoundMiddlePacket;
import protocolsupport.protocol.packet.middleimpl.ClientBoundPacketData;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.protocol.storage.NetworkDataCache;
import protocolsupport.protocol.utils.registry.MiddleTransformerRegistry;
import protocolsupport.utils.netty.Allocator;
import protocolsupport.utils.netty.MessageToMessageEncoder;
import protocolsupport.utils.recyclable.RecyclableCollection;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.network.NetworkState;

public abstract class AbstractPacketEncoder
extends MessageToMessageEncoder<ByteBuf> {
    protected final Connection connection;
    protected final NetworkDataCache cache;
    protected final MiddleTransformerRegistry<ClientBoundMiddlePacket<RecyclableCollection<ClientBoundPacketData>>> registry = new MiddleTransformerRegistry();
    private final ProtocolSupportPacketDataSerializer middlebuffer = new ProtocolSupportPacketDataSerializer(null, ProtocolVersion.getLatest());
    private final boolean varintPacketId;

    public AbstractPacketEncoder(Connection connection, NetworkDataCache storage) {
        this.connection = connection;
        this.cache = storage;
        this.registry.setCallBack(object -> {
            object.setConnection(this.connection);
            object.setSharedStorage(this.cache);
        });
        this.varintPacketId = connection.getVersion().isAfterOrEq(ProtocolVersion.MINECRAFT_1_7_5);
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf packet, List<Object> output) throws InstantiationException, IllegalAccessException {
        if (!packet.isReadable()) {
            return;
        }
        NetworkState currentProtocol = ServerPlatform.get().getMiscUtils().getNetworkStateFromChannel(ctx.channel());
        this.middlebuffer.setBuf(packet);
        int packetId = this.middlebuffer.readVarInt();
        ClientBoundMiddlePacket<RecyclableCollection<ClientBoundPacketData>> packetTransformer = this.registry.getTransformer(currentProtocol, packetId);
        packetTransformer.readFromServerData(this.middlebuffer);
        packetTransformer.handle();
        try (RecyclableCollection<ClientBoundPacketData> data = packetTransformer.toData(this.connection.getVersion());){
            for (ClientBoundPacketData packetdata : data) {
                ByteBuf senddata = Allocator.allocateBuffer();
                int newPacketId = this.getNewPacketId(currentProtocol, packetdata.getPacketId());
                if (this.varintPacketId) {
                    ProtocolSupportPacketDataSerializer.writeVarInt(senddata, newPacketId);
                } else {
                    senddata.writeByte(newPacketId);
                }
                senddata.writeBytes((ByteBuf)packetdata);
                output.add(senddata);
            }
        }
    }

    protected abstract int getNewPacketId(NetworkState var1, int var2);
}

