/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.timeout;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SimpleReadTimeoutHandler
extends ChannelInboundHandlerAdapter {
    private volatile ScheduledFuture<?> timeoutTask;
    protected final long timeoutTime;
    protected long lastReadTime;

    public SimpleReadTimeoutHandler(int timeout) {
        this(timeout, TimeUnit.SECONDS);
    }

    public SimpleReadTimeoutHandler(long timeout, TimeUnit tu) {
        this.timeoutTime = tu.toMillis(timeout);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) {
        this.setLastRead();
        ctx.fireChannelRead(message);
    }

    public void setLastRead() {
        this.lastReadTime = System.currentTimeMillis();
    }

    private void initialize(final ChannelHandlerContext ctx) {
        this.lastReadTime = System.currentTimeMillis();
        this.timeoutTask = ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (ctx.channel().isOpen()) {
                    long untilTimeout = SimpleReadTimeoutHandler.this.timeoutTime - (System.currentTimeMillis() - SimpleReadTimeoutHandler.this.lastReadTime);
                    if (untilTimeout <= 0L) {
                        ctx.fireExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
                    } else {
                        ctx.executor().schedule((Runnable)this, untilTimeout, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }, this.timeoutTime, TimeUnit.MILLISECONDS);
    }

    private void destroy() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
            this.timeoutTask = null;
        }
    }
}

