/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.middle.clientbound.play;

import org.bukkit.Location;
import protocolsupport.protocol.packet.middle.ClientBoundMiddlePacket;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;

public abstract class MiddlePosition<T>
extends ClientBoundMiddlePacket<T> {
    protected double xOrig;
    protected double yOrig;
    protected double zOrig;
    protected float yawOrig;
    protected float pitchOrig;
    protected double x;
    protected double y;
    protected double z;
    protected float yaw;
    protected float pitch;
    protected int flags;
    protected int teleportConfirmId;

    @Override
    public void readFromServerData(ProtocolSupportPacketDataSerializer serializer) {
        this.xOrig = this.x = serializer.readDouble();
        this.yOrig = this.y = serializer.readDouble();
        this.zOrig = this.z = serializer.readDouble();
        this.yawOrig = this.yaw = serializer.readFloat();
        this.pitchOrig = this.pitch = serializer.readFloat();
        this.flags = serializer.readByte();
        if (this.flags != 0) {
            Location location = this.connection.getPlayer().getLocation();
            if ((this.flags & 1) != 0) {
                this.x += location.getX();
            }
            if ((this.flags & 2) != 0) {
                this.y += location.getY();
            }
            if ((this.flags & 4) != 0) {
                this.z += location.getX();
            }
            if ((this.flags & 8) != 0) {
                this.yaw += location.getYaw();
            }
            if ((this.flags & 0x10) != 0) {
                this.pitch += location.getPitch();
            }
        }
        this.teleportConfirmId = serializer.readVarInt();
    }

    @Override
    public void handle() {
        if (this.teleportConfirmId != 0) {
            this.cache.setTeleportLocation(this.x, this.y, this.z, this.teleportConfirmId);
        }
    }
}

