/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.landFlags;

import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class Build
extends Landflag {
    public Build() {
        super("Construction", "Donne la permission de placer|et de casser des blocs ainsi que d'\u00e9diter|des choses comme les itemframes et|les noteblocks.", new ItemStack(Material.COBBLESTONE), "Autorise la construction", "peuvent construire.", "Interdit la construction", "ne peuvent pas construire.");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void blockPlace(BlockPlaceEvent event) {
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getBlock().getLocation());
        if (land == null) {
            return;
        }
        Player p = event.getPlayer();
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous n'\u00eates pas autoris\u00e9s \u00e0 construire sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void blockBreak(BlockBreakEvent event) {
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getBlock().getLocation());
        if (land == null) {
            return;
        }
        Player p = event.getPlayer();
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous n'\u00eates ps autoris\u00e9s \u00e0 d\u00e9truire sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void liquidEmpty(PlayerBucketEmptyEvent event) {
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getBlockClicked().getLocation());
        if (land == null) {
            return;
        }
        Player p = event.getPlayer();
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas placer \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void liquidFill(PlayerBucketFillEvent event) {
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getBlockClicked().getLocation());
        if (land == null) {
            return;
        }
        Player p = event.getPlayer();
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void paintingFrameBreak(HangingBreakByEntityEvent event) {
        Player p;
        Hanging victim = event.getEntity();
        Entity remover = event.getRemover();
        LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
        if (land == null) {
            return;
        }
        if (remover.getType() == EntityType.PLAYER && !land.hasPermTo(p = (Player)remover, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas casser \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void interactWithArmorStand(PlayerInteractAtEntityEvent event) {
        if (!event.getRightClicked().getType().equals((Object)EntityType.ARMOR_STAND)) {
            return;
        }
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getRightClicked().getLocation());
        if (land == null) {
            return;
        }
        if (!land.hasPermTo(event.getPlayer(), this)) {
            event.getPlayer().sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain!");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void destroyArmorStand(EntityDamageByEntityEvent event) {
        Player attacker;
        Arrow projectile;
        Player attacker2;
        Entity victim = event.getEntity();
        if (!victim.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return;
        }
        LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
        if (land == null) {
            return;
        }
        if (event.getDamager().getType().equals((Object)EntityType.PLAYER) && !land.hasPermTo(attacker2 = (Player)event.getDamager(), this)) {
            attacker2.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
        if (event.getDamager().getType().equals((Object)EntityType.ARROW) && (projectile = (Arrow)event.getDamager()).getShooter() instanceof Player && !land.hasPermTo(attacker = (Player)projectile.getShooter(), this)) {
            attacker.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void removeItemFromFrame(EntityDamageByEntityEvent event) {
        Entity victim = event.getEntity();
        if (!victim.getType().equals((Object)EntityType.ITEM_FRAME)) {
            return;
        }
        Entity attacker = event.getDamager();
        if (attacker.getType() == EntityType.PLAYER) {
            Player p = (Player)attacker;
            LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
            if (land == null) {
                return;
            }
            if (!land.hasPermTo(p, this)) {
                p.sendMessage(ChatColor.RED + "Vous ne pouvez pas casser \u00e7a sur ce terrain.");
                event.setCancelled(true);
            }
        } else if (attacker.getType() == EntityType.ARROW) {
            Arrow a = (Arrow)attacker;
            if (!(a.getShooter() instanceof Player)) {
                return;
            }
            Player p = (Player)a.getShooter();
            LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
            if (land == null) {
                return;
            }
            if (!land.hasPermTo(p, this)) {
                p.sendMessage(ChatColor.RED + "Vous ne pouvez pas casser \u00e7a sur ce terrain.");
                event.setCancelled(true);
            }
        } else {
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void removeItemFromFrame(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player p = event.getPlayer();
        if (!entity.getType().equals((Object)EntityType.ITEM_FRAME)) {
            return;
        }
        ItemFrame iFrame = (ItemFrame)entity;
        if (iFrame.getItem() != null && !iFrame.getItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        LowOwnedLand land = LowOwnedLand.getApplicableLand(entity.getLocation());
        if (land == null) {
            return;
        }
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas casser \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void rotateItemInFrame(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player p = event.getPlayer();
        if (!entity.getType().equals((Object)EntityType.ITEM_FRAME)) {
            return;
        }
        ItemFrame iFrame = (ItemFrame)entity;
        if (iFrame.getItem().equals(null) || iFrame.getItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        LowOwnedLand land = LowOwnedLand.getApplicableLand(entity.getLocation());
        if (land == null) {
            return;
        }
        if (!land.hasPermTo(p, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void paintingFramePlace(HangingPlaceEvent event) {
        Player p;
        Player placer = event.getPlayer();
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getBlock().getLocation());
        if (land == null) {
            return;
        }
        if (placer.getType() == EntityType.PLAYER && !land.hasPermTo(p = placer, this)) {
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas placer \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void CropTrampleOrFireCharge(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Player p = event.getPlayer();
        if (p != null && event.getAction().equals((Object)Action.PHYSICAL) && event.getClickedBlock().getType() == Material.SOIL) {
            LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getClickedBlock().getLocation());
            if (land == null) {
                return;
            }
            if (land.hasPermTo(p, this)) {
                return;
            }
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas d\u00e9truire \u00e7a sur ce terrain.");
            event.setCancelled(true);
            return;
        }
        ItemStack item = event.getItem();
        if (p != null && item != null && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getItem().getType().equals((Object)Material.FIREBALL)) {
            LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getClickedBlock().getLocation());
            if (land == null) {
                return;
            }
            if (land.hasPermTo(p, this)) {
                return;
            }
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void protectBlockStates(PlayerInteractEvent event) {
        Material[] blockedItems = new Material[]{Material.NOTE_BLOCK, Material.REDSTONE_COMPARATOR_OFF, Material.REDSTONE_COMPARATOR_ON, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.FLOWER_POT, Material.CAKE_BLOCK};
        if (event.getClickedBlock() == null) {
            return;
        }
        Player p = event.getPlayer();
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && Arrays.asList(blockedItems).contains(event.getClickedBlock().getType())) {
            LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getClickedBlock().getLocation());
            if (land == null) {
                return;
            }
            if (land.hasPermTo(p, this)) {
                return;
            }
            p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faier \u00e7a sur ce terrain.");
            event.setCancelled(true);
        }
    }
}

