/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.NumberConversions;

public class ListPlayer
implements LandlordCommand {
    private Landlord plugin;

    public ListPlayer(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (args.length <= 1) {
            sender.sendMessage(ChatColor.RED + "usage: /" + label + " listplayer <player> [page#]");
            return true;
        }
        String owner = args[1];
        if (!sender.hasPermission("landlord.admin.list")) {
            sender.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
            return true;
        }
        int pageNumber = 1;
        if (args.length > 2) {
            try {
                pageNumber = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                return true;
            }
        }
        String playerName = args[1];
        List myLand = this.plugin.getDatabase().find(OwnedLand.class).where().ieq("ownerName", playerName).findList();
        if (myLand.size() == 0) {
            sender.sendMessage(ChatColor.YELLOW + owner + " n'est le propri\u00e9taire d'aucun terrain!");
        } else {
            String header = ChatColor.DARK_GREEN + " | Coordonn\u00e9es - Coordonn\u00e9es du chunk - Nom du monde |     \n";
            ArrayList<String> landList = new ArrayList<String>();
            for (OwnedLand aMyLand : myLand) {
                LowOwnedLand land = aMyLand.getLowLand();
                landList.add(ChatColor.GOLD + " (" + land.getXBlock() + ", " + land.getZBlock() + ") - (" + land.getX() + ", " + land.getZ() + ") - " + land.getWorldName() + "\n");
            }
            int numPerPage = 7;
            int numPages = NumberConversions.ceil((double)((double)landList.size() / 7.0));
            if (pageNumber > numPages) {
                sender.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                return true;
            }
            String pMsg = ChatColor.DARK_GREEN + "--- " + ChatColor.YELLOW + "Terrains de " + owner + ChatColor.DARK_GREEN + " ---" + ChatColor.YELLOW + " Page " + pageNumber + ChatColor.DARK_GREEN + " ---\n" + header;
            if (pageNumber == numPages) {
                int i = 7 * pageNumber - 7;
                while (i < landList.size()) {
                    pMsg = String.valueOf(pMsg) + (String)landList.get(i);
                    ++i;
                }
                pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "------------------------------";
            } else {
                int i = 7 * pageNumber - 7;
                while (i < 7 * pageNumber) {
                    pMsg = String.valueOf(pMsg) + (String)landList.get(i);
                    ++i;
                }
                pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "--- fa\u00eetes" + ChatColor.YELLOW + " /" + label + " listplayer " + (pageNumber + 1) + ChatColor.DARK_GREEN + " pour voir la page suivante (" + pageNumber + "/" + numPages + ") ---";
            }
            sender.sendMessage(pMsg);
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.admin.list")) {
            return null;
        }
        String usage = "/#{label} #{cmd} <player>";
        String desc = "Liste les terrains des autres joueurs.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"listplayer"};
    }
}

