/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

public class Friends
implements LandlordCommand {
    private Landlord plugin;

    public Friends(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.own")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            Chunk currChunk = player.getLocation().getChunk();
            LowOwnedLand land = LowOwnedLand.getLandFromDatabase(currChunk.getX(), currChunk.getZ(), currChunk.getWorld().getName());
            if (land == null || !land.getOwnerName().equalsIgnoreCase(player.getName()) && !player.hasPermission("landlord.admin.friends")) {
                player.sendMessage(ChatColor.RED + "Vous ne poss\u00e9dez pas ce terrain.");
                return true;
            }
            land.getOwnerName().equalsIgnoreCase(player.getName());
            if (this.plugin.getConfig().getBoolean("options.particleEffects", true)) {
                land.highlightLand(player, Effect.HEART, 3);
            }
            int pageNumber = 1;
            if (args.length > 1 && args[0].equals("friends")) {
                try {
                    pageNumber = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                    return true;
                }
            }
            String header = ChatColor.DARK_GREEN + "----- Friends de ce terrain -----\n";
            ArrayList<String> friendList = new ArrayList<String>();
            if (land.getFriends().isEmpty()) {
                player.sendMessage(ChatColor.YELLOW + "Ce terrain n'a pas de friends.");
                return true;
            }
            for (Friend f : land.getFriends()) {
                String fr = ChatColor.DARK_GREEN + " - " + ChatColor.GOLD + f.getName() + ChatColor.DARK_GREEN + " - ";
                fr = Bukkit.getPlayer((String)f.getName()) != null && Bukkit.getPlayer((String)f.getName()).isOnline() ? String.valueOf(fr) + ChatColor.GREEN + ChatColor.ITALIC + " Connect\u00e9" : String.valueOf(fr) + ChatColor.RED + ChatColor.ITALIC + " D\u00e9connect\u00e9";
                fr = String.valueOf(fr) + "\n";
                friendList.add(fr);
            }
            int numPerPage = 8;
            int numPages = NumberConversions.ceil((double)((double)friendList.size() / 8.0));
            if (pageNumber > numPages) {
                sender.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                return true;
            }
            String pMsg = header;
            if (pageNumber == numPages) {
                int i = 8 * pageNumber - 8;
                while (i < friendList.size()) {
                    pMsg = String.valueOf(pMsg) + (String)friendList.get(i);
                    ++i;
                }
                pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "------------------------------";
            } else {
                int i = 8 * pageNumber - 8;
                while (i < 8 * pageNumber) {
                    pMsg = String.valueOf(pMsg) + (String)friendList.get(i);
                    ++i;
                }
                pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "--- fa\u00eetes" + ChatColor.YELLOW + " /" + label + " friends " + (pageNumber + 1) + ChatColor.DARK_GREEN + " pour voir la prochaine page (" + pageNumber + "/" + numPages + ") ---";
            }
            player.sendMessage(pMsg);
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd}";
        String desc = "Liste les friends du terrain.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"friends"};
    }
}

