/*
 * Decompiled with CFR 0.152.
 */
package com.mifmif.common.regex;

import com.mifmif.common.regex.util.Iterator;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayDeque;
import java.util.Deque;

public class GenerexIterator
implements Iterator {
    private final Deque<Step> steps = new ArrayDeque<Step>();
    private final StringBuilder stringBuilder;
    private boolean found;

    public GenerexIterator(State initialState) {
        int initialCapacity;
        if (initialState.isAccept() && initialState.getTransitions().isEmpty()) {
            this.found = true;
            initialCapacity = 0;
        } else {
            this.steps.push(new Step(initialState));
            initialCapacity = 16;
        }
        this.stringBuilder = new StringBuilder(initialCapacity);
    }

    @Override
    public boolean hasNext() {
        if (this.found) {
            return true;
        }
        if (this.steps.isEmpty()) {
            return false;
        }
        this.nextImpl();
        return this.found;
    }

    private void nextImpl() {
        while (!this.steps.isEmpty() && !this.found) {
            Step currentStep = this.steps.pop();
            this.found = currentStep.build(this.stringBuilder, this.steps);
        }
    }

    @Override
    public String next() {
        if (!this.found) {
            this.nextImpl();
        }
        if (!this.found) {
            throw new IllegalStateException();
        }
        this.found = false;
        return this.stringBuilder.toString();
    }

    private static class Step {
        private java.util.Iterator<Transition> iteratorTransitions;
        private Transition currentTransition;
        private char currentChar;

        public Step(State state) {
            this.iteratorTransitions = state.getSortedTransitions(true).iterator();
        }

        public boolean build(StringBuilder stringBuilder, Deque<Step> steps) {
            if (this.hasCurrentTransition()) {
                this.currentChar = (char)(this.currentChar + '\u0001');
            } else if (!this.moveToNextTransition()) {
                Step.removeLastChar(stringBuilder);
                return false;
            }
            if (this.currentChar <= this.currentTransition.getMax()) {
                stringBuilder.append(this.currentChar);
                if (this.currentTransition.getDest().isAccept()) {
                    this.pushForDestinationOfCurrentTransition(steps);
                    if (this.currentChar >= this.currentTransition.getMax()) {
                        this.currentTransition = null;
                    }
                    return true;
                }
                this.pushForDestinationOfCurrentTransition(steps);
                return false;
            }
            steps.push(this);
            this.currentTransition = null;
            return false;
        }

        private boolean hasCurrentTransition() {
            return this.currentTransition != null;
        }

        private boolean moveToNextTransition() {
            if (!this.iteratorTransitions.hasNext()) {
                return false;
            }
            this.currentTransition = this.iteratorTransitions.next();
            this.currentChar = this.currentTransition.getMin();
            return true;
        }

        private static void removeLastChar(StringBuilder stringBuilder) {
            int len = stringBuilder.length();
            if (len > 0) {
                stringBuilder.deleteCharAt(len - 1);
            }
        }

        private void pushForDestinationOfCurrentTransition(Deque<Step> steps) {
            steps.push(this);
            steps.push(new Step(this.currentTransition.getDest()));
        }
    }
}

