/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.pingresponse;

import java.lang.reflect.Type;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.chat.modifiers.ClickAction;
import protocolsupport.api.chat.modifiers.HoverAction;
import protocolsupport.api.chat.modifiers.Modifier;
import protocolsupport.libs.com.google.gson.Gson;
import protocolsupport.libs.com.google.gson.GsonBuilder;
import protocolsupport.libs.com.google.gson.JsonDeserializationContext;
import protocolsupport.libs.com.google.gson.JsonDeserializer;
import protocolsupport.libs.com.google.gson.JsonElement;
import protocolsupport.libs.com.google.gson.JsonObject;
import protocolsupport.libs.com.google.gson.JsonParseException;
import protocolsupport.libs.com.google.gson.JsonSerializationContext;
import protocolsupport.libs.com.google.gson.JsonSerializer;
import protocolsupport.protocol.utils.pingresponse.PingResponsePlayers;
import protocolsupport.protocol.utils.pingresponse.PingResponseProtocolData;
import protocolsupport.utils.JsonUtils;
import protocolsupport.utils.chat.ClickActionSerializer;
import protocolsupport.utils.chat.ComponentSerializer;
import protocolsupport.utils.chat.HoverActionSerializer;
import protocolsupport.utils.chat.ModifierSerializer;

public class PingResponse {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)PingResponse.class), new Serializer()).registerTypeAdapter((Type)((Object)PingResponseProtocolData.class), new PingResponseProtocolData.Serializer()).registerTypeAdapter((Type)((Object)PingResponsePlayers.class), new PingResponsePlayers.Serializer()).registerTypeHierarchyAdapter(BaseComponent.class, new ComponentSerializer()).registerTypeHierarchyAdapter(Modifier.class, new ModifierSerializer()).registerTypeHierarchyAdapter(ClickAction.class, new ClickActionSerializer()).registerTypeHierarchyAdapter(HoverAction.class, new HoverActionSerializer()).create();
    private PingResponseProtocolData protocoldata;
    private BaseComponent motd;
    private PingResponsePlayers players;
    private String icon;

    public static PingResponse fromJson(String json) {
        return gson.fromJson(json, PingResponse.class);
    }

    public static String toJson(PingResponse response) {
        return gson.toJson(response);
    }

    public PingResponse() {
    }

    public PingResponse(PingResponseProtocolData protocoldata, BaseComponent motd, PingResponsePlayers players, String icon) {
        this.protocoldata = protocoldata;
        this.motd = motd;
        this.players = players;
        this.icon = icon;
    }

    public PingResponseProtocolData getProtocolData() {
        return this.protocoldata;
    }

    public void setProtocolData(PingResponseProtocolData protocoldata) {
        this.protocoldata = protocoldata;
    }

    public BaseComponent getMotd() {
        return this.motd;
    }

    public void setMotd(BaseComponent motd) {
        this.motd = motd;
    }

    public PingResponsePlayers getPlayers() {
        return this.players;
    }

    public void setPlayers(PingResponsePlayers players) {
        this.players = players;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public static class Serializer
    implements JsonDeserializer<PingResponse>,
    JsonSerializer<PingResponse> {
        @Override
        public PingResponse deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getObject(jsonElement, "status");
            PingResponse ping = new PingResponse();
            if (jsonObject.has("version")) {
                ping.setProtocolData((PingResponseProtocolData)ctx.deserialize(jsonObject.get("version"), (Type)((Object)PingResponseProtocolData.class)));
            }
            if (jsonObject.has("description")) {
                ping.setMotd((BaseComponent)ctx.deserialize(jsonObject.get("description"), (Type)((Object)BaseComponent.class)));
            }
            if (jsonObject.has("players")) {
                ping.setPlayers((PingResponsePlayers)ctx.deserialize(jsonObject.get("players"), (Type)((Object)PingResponsePlayers.class)));
            }
            if (jsonObject.has("favicon")) {
                ping.setIcon(JsonUtils.getString(jsonObject, "favicon"));
            }
            return ping;
        }

        @Override
        public JsonElement serialize(PingResponse ping, Type type, JsonSerializationContext ctx) {
            JsonObject jsonObject = new JsonObject();
            if (ping.getProtocolData() != null) {
                jsonObject.add("version", ctx.serialize(ping.getProtocolData()));
            }
            if (ping.getMotd() != null) {
                jsonObject.add("description", ctx.serialize(ping.getMotd()));
            }
            if (ping.getPlayers() != null) {
                jsonObject.add("players", ctx.serialize(ping.getPlayers()));
            }
            if (ping.getIcon() != null) {
                jsonObject.addProperty("favicon", ping.getIcon());
            }
            return jsonObject;
        }
    }
}

