/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.tileentity;

import java.util.HashMap;

public enum TileEntityUpdateType {
    UNKNOWN,
    MOB_SPAWNER,
    COMMAND_BLOCK,
    BEACON,
    SKULL,
    FLOWER_POT,
    BANNER,
    STRUCTURE,
    END_GATEWAY,
    SIGN,
    SHULKER_BOX;

    private static final HashMap<String, TileEntityUpdateType> updateTypes;

    public static TileEntityUpdateType fromType(String type) {
        return updateTypes.getOrDefault(type, UNKNOWN);
    }

    public int getId() {
        return this.ordinal();
    }

    public static TileEntityUpdateType fromId(int id) {
        return TileEntityUpdateType.values()[id];
    }

    static {
        updateTypes = new HashMap();
        updateTypes.put("minecraft:mob_spawner", MOB_SPAWNER);
        updateTypes.put("minecraft:command_block", COMMAND_BLOCK);
        updateTypes.put("minecraft:beacon", BEACON);
        updateTypes.put("minecraft:skull", SKULL);
        updateTypes.put("minecraft:flower_pot", FLOWER_POT);
        updateTypes.put("minecraft:banner", BANNER);
        updateTypes.put("minecraft:structure_block", STRUCTURE);
        updateTypes.put("minecraft:end_gateway", END_GATEWAY);
        updateTypes.put("minecraft:sign", SIGN);
    }
}

