/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.id;

import java.util.HashMap;
import protocolsupport.libs.gnu.trove.map.hash.TIntIntHashMap;

public class RemappingTable {

    public static class GenericRemappingTable<T>
    extends RemappingTable {
        protected final HashMap<T, T> table = new HashMap();

        public void setRemap(T from, T to) {
            this.table.put(from, to);
        }

        public T getRemap(T from) {
            return this.table.getOrDefault(from, from);
        }
    }

    public static class HashMapBasedIdRemappingTable
    extends IdRemappingTable {
        protected final TIntIntHashMap table = new TIntIntHashMap(16, 0.75f, -1, -1);

        @Override
        public void setRemap(int from, int to) {
            this.table.put(from, to);
        }

        @Override
        public int getRemap(int id) {
            int r = this.table.get(id);
            return r != -1 ? r : id;
        }
    }

    public static class ArrayBasedIdRemappingTable
    extends IdRemappingTable {
        protected final int[] table;

        public ArrayBasedIdRemappingTable(int size) {
            this.table = new int[size];
            for (int i = 0; i < this.table.length; ++i) {
                this.table[i] = i;
            }
        }

        @Override
        public void setRemap(int from, int to) {
            this.table[from] = to;
        }

        @Override
        public int getRemap(int id) {
            return this.table[id];
        }
    }

    public static abstract class IdRemappingTable
    extends RemappingTable {
        public abstract void setRemap(int var1, int var2);

        public abstract int getRemap(int var1);
    }
}

