/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.handler;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import protocolsupport.api.Connection;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.packet.handler.AbstractLoginListener;
import protocolsupport.protocol.utils.MinecraftEncryption;
import protocolsupport.protocol.utils.authlib.MinecraftSessionService;
import protocolsupport.zplatform.ServerPlatform;

public class PlayerLookupUUID {
    private final AbstractLoginListener listener;
    private final boolean isOnlineMode;

    public PlayerLookupUUID(AbstractLoginListener listener, boolean isOnlineMode) {
        this.listener = listener;
        this.isOnlineMode = isOnlineMode;
    }

    public void run() {
        String joinName = this.listener.profile.getName();
        try {
            if (!this.isOnlineMode) {
                this.listener.initOfflineModeGameProfile();
                this.fireLoginEvents();
                return;
            }
            String hash = new BigInteger(MinecraftEncryption.createHash(ServerPlatform.get().getMiscUtils().getEncryptionKeyPair().getPublic(), this.listener.loginKey)).toString(16);
            this.listener.profile = MinecraftSessionService.hasJoinedServer(joinName, hash);
            this.fireLoginEvents();
        }
        catch (MinecraftSessionService.AuthenticationUnavailableException authenticationunavailableexception) {
            this.listener.disconnect("Authentication servers are down. Please try again later, sorry!");
            Bukkit.getLogger().severe("Couldn't verify username because servers are unavailable");
        }
        catch (Exception exception) {
            this.listener.disconnect("Failed to verify username!");
            Bukkit.getLogger().log(Level.SEVERE, "Exception verifying " + joinName, exception);
        }
    }

    private void fireLoginEvents() throws InterruptedException, ExecutionException {
        if (!this.listener.networkManager.isConnected()) {
            return;
        }
        String playerName = this.listener.profile.getName();
        InetSocketAddress saddress = this.listener.networkManager.getAddress();
        InetAddress address = saddress.getAddress();
        PlayerPropertiesResolveEvent propResolve = new PlayerPropertiesResolveEvent((Connection)ConnectionImpl.getFromChannel(this.listener.networkManager.getChannel()), playerName, this.listener.profile.getProperties().values());
        Bukkit.getPluginManager().callEvent((Event)propResolve);
        this.listener.profile.clearProperties();
        for (PlayerPropertiesResolveEvent.ProfileProperty property : propResolve.getProperties().values()) {
            this.listener.profile.addProperty(property);
        }
        UUID uniqueId = this.listener.profile.getUUID();
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        Bukkit.getPluginManager().callEvent((Event)asyncEvent);
        PlayerPreLoginEvent syncEvent = new PlayerPreLoginEvent(playerName, address, uniqueId);
        if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
            syncEvent.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
        }
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0 && ServerPlatform.get().getMiscUtils().callSyncTask(() -> {
            Bukkit.getPluginManager().callEvent((Event)syncEvent);
            return syncEvent.getResult();
        }).get() != PlayerPreLoginEvent.Result.ALLOWED) {
            this.listener.disconnect(syncEvent.getKickMessage());
            return;
        }
        if (syncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
            this.listener.disconnect(syncEvent.getKickMessage());
            return;
        }
        Bukkit.getLogger().info("UUID of player " + this.listener.profile.getName() + " is " + this.listener.profile.getUUID());
        this.listener.setReadyToAccept();
    }
}

