/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.handler;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLoginEvent;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.PlayerLoginFinishEvent;
import protocolsupport.api.events.PlayerSyncLoginEvent;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.packet.handler.IHasProfile;
import protocolsupport.protocol.pipeline.ChannelHandlers;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public abstract class AbstractLoginListenerPlay
implements IHasProfile {
    protected final NetworkManagerWrapper networkManager;
    protected final GameProfile profile;
    protected final boolean onlineMode;
    protected final String hostname;
    protected boolean ready;
    protected int keepAliveTicks = 1;

    protected AbstractLoginListenerPlay(NetworkManagerWrapper networkmanager, GameProfile profile, boolean onlineMode, String hostname) {
        this.networkManager = networkmanager;
        this.profile = profile;
        this.onlineMode = onlineMode;
        this.hostname = hostname;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    public void finishLogin() {
        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginSuccessPacket(this.profile), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                AbstractLoginListenerPlay.this.networkManager.setProtocol(NetworkState.PLAY);
            }
        }, new GenericFutureListener[0]);
        this.keepConnection();
        PlayerLoginFinishEvent event = new PlayerLoginFinishEvent(ConnectionImpl.getFromChannel(this.networkManager.getChannel()), this.profile.getName(), this.profile.getUUID(), this.onlineMode);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isLoginDenied()) {
            this.disconnect(event.getDenyLoginMessage());
            return;
        }
        this.ready = true;
    }

    public void tick() {
        if (this.keepAliveTicks++ % 80 == 0) {
            this.keepConnection();
        }
        if (this.ready) {
            this.tryJoin();
        }
    }

    private void tryJoin() {
        List<Player> toKick = Bukkit.getOnlinePlayers().stream().filter(player -> player.getUniqueId().equals(this.profile.getUUID())).collect(Collectors.toList());
        if (!toKick.isEmpty()) {
            toKick.forEach(player -> player.kickPlayer("You logged in from another location"));
            return;
        }
        this.ready = false;
        JoinData joindata = this.createJoinData();
        PlayerSyncLoginEvent syncloginevent = new PlayerSyncLoginEvent((Connection)ConnectionImpl.getFromChannel(this.networkManager.getChannel()), joindata.player);
        Bukkit.getPluginManager().callEvent((Event)syncloginevent);
        if (syncloginevent.isLoginDenied()) {
            this.disconnect(syncloginevent.getDenyLoginMessage());
            joindata.close();
            return;
        }
        PlayerLoginEvent bukkitevent = new PlayerLoginEvent(joindata.player, this.hostname, this.networkManager.getAddress().getAddress(), this.networkManager.getRawAddress().getAddress());
        this.checkBans(bukkitevent, joindata.data);
        Bukkit.getPluginManager().callEvent((Event)bukkitevent);
        if (bukkitevent.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            this.disconnect(bukkitevent.getKickMessage());
            joindata.close();
            return;
        }
        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createEmptyCustomPayloadPacket("PS|FinishLogin"));
        this.joinGame(joindata.data);
    }

    protected void keepConnection() {
        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createEmptyCustomPayloadPacket("PS|KeepAlive"));
        ChannelHandlers.getTimeoutHandler(this.networkManager.getChannel().pipeline()).setLastRead();
    }

    protected String getConnectionRepr() {
        return this.profile != null ? this.profile + " (" + this.networkManager.getAddress() + ")" : this.networkManager.getAddress().toString();
    }

    public void disconnect(String s) {
        try {
            Bukkit.getLogger().info("Disconnecting " + this.getConnectionRepr() + ": " + s);
            if (ConnectionImpl.getFromChannel(this.networkManager.getChannel()).getVersion().isBetween(ProtocolVersion.MINECRAFT_1_7_5, ProtocolVersion.MINECRAFT_1_7_10)) {
                this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createFakeJoinGamePacket());
                this.networkManager.getChannel().eventLoop().schedule(() -> this.disconnect0(s), 50L, TimeUnit.MILLISECONDS);
            } else {
                this.disconnect0(s);
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Error whilst disconnecting player", exception);
        }
    }

    protected void disconnect0(final String s) {
        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createPlayDisconnectPacket(s), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) {
                AbstractLoginListenerPlay.this.networkManager.close(s);
            }
        }, new GenericFutureListener[0]);
    }

    protected abstract JoinData createJoinData();

    protected abstract void checkBans(PlayerLoginEvent var1, Object[] var2);

    protected abstract void joinGame(Object[] var1);

    protected abstract class JoinData {
        public final Player player;
        public final Object[] data;

        public JoinData(Player player, Object ... data) {
            this.player = player;
            this.data = data;
        }

        protected abstract void close();
    }
}

