/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper;

import protocolsupport.libs.gnu.trove.map.hash.TObjectIntHashMap;

public class LegacyPotion {
    private static final TObjectIntHashMap<String> potionToLegacyIds = new TObjectIntHashMap();

    private static void register(String name, int id) {
        potionToLegacyIds.put(name, id);
        potionToLegacyIds.put("minecraft:" + name, id);
    }

    public static int toLegacyId(String nbttag, boolean isThrowable) {
        int value = potionToLegacyIds.get(nbttag);
        return isThrowable ? value + 8192 : value;
    }

    public static String getBasicTypeName(String nbttag) {
        switch (nbttag) {
            case "mundane": 
            case "minecraft:mundane": {
                return "Mundane Potion";
            }
            case "thick": 
            case "minecraft:thick": {
                return "Thick Potion";
            }
            case "awkward": 
            case "minecraft:awkward": {
                return "Awkward Potion";
            }
        }
        return null;
    }

    static {
        LegacyPotion.register("night_vision", 8198);
        LegacyPotion.register("long_night_vision", 8262);
        LegacyPotion.register("invisibility", 8206);
        LegacyPotion.register("long_invisibility", 8270);
        LegacyPotion.register("leaping", 8203);
        LegacyPotion.register("long_leaping", 8267);
        LegacyPotion.register("strong_leaping", 8235);
        LegacyPotion.register("fire_resistance", 8195);
        LegacyPotion.register("long_fire_resistance", 8259);
        LegacyPotion.register("swiftness", 8194);
        LegacyPotion.register("long_swiftness", 8258);
        LegacyPotion.register("strong_swiftness", 8226);
        LegacyPotion.register("slowness", 8202);
        LegacyPotion.register("long_slowness", 8266);
        LegacyPotion.register("water_breathing", 8205);
        LegacyPotion.register("long_water_breathing", 8269);
        LegacyPotion.register("healing", 8197);
        LegacyPotion.register("strong_healing", 8229);
        LegacyPotion.register("harming", 8204);
        LegacyPotion.register("strong_harming", 8236);
        LegacyPotion.register("poison", 8196);
        LegacyPotion.register("long_poison", 8260);
        LegacyPotion.register("strong_poison", 8228);
        LegacyPotion.register("regeneration", 8193);
        LegacyPotion.register("long_regeneration", 8257);
        LegacyPotion.register("strong_regeneration", 8225);
        LegacyPotion.register("strength", 8201);
        LegacyPotion.register("long_strength", 8265);
        LegacyPotion.register("strong_strength", 8233);
        LegacyPotion.register("weakness", 8200);
        LegacyPotion.register("long_weakness", 8264);
    }
}

