/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import org.bukkit.entity.Player;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.storage.ProtocolStorage;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public abstract class ConnectionImpl
extends Connection {
    protected static final AttributeKey<ConnectionImpl> key = AttributeKey.valueOf((String)"PSConnectionImpl");
    protected final NetworkManagerWrapper networkmanager;

    public ConnectionImpl(NetworkManagerWrapper networkmanager) {
        this.networkmanager = networkmanager;
    }

    public NetworkManagerWrapper getNetworkManagerWrapper() {
        return this.networkmanager;
    }

    @Override
    public Object getNetworkManager() {
        return this.networkmanager.unwrap();
    }

    @Override
    public boolean isConnected() {
        return this.networkmanager.isConnected();
    }

    @Override
    public InetSocketAddress getRawAddress() {
        return this.networkmanager.getRawAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.networkmanager.getAddress();
    }

    @Override
    public void changeAddress(InetSocketAddress newRemote) {
        InetSocketAddress primaryaddr = this.networkmanager.getRawAddress();
        ProtocolStorage.addAddress(primaryaddr, newRemote);
        this.networkmanager.setAddress(newRemote);
    }

    @Override
    public Player getPlayer() {
        return this.networkmanager.getBukkitPlayer();
    }

    public static ConnectionImpl getFromChannel(Channel channel) {
        return (ConnectionImpl)channel.attr(key).get();
    }

    public void storeInChannel(Channel channel) {
        channel.attr(key).set((Object)this);
    }

    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    public boolean handlePacketSend(Object packet) {
        boolean canSend = true;
        for (Connection.PacketSendListener listener : this.sendListeners) {
            try {
                if (listener.onPacketSending(packet)) continue;
                canSend = false;
            }
            catch (Throwable t) {
                System.err.println("Error occured while handling packet sending");
                t.printStackTrace();
            }
        }
        return canSend;
    }

    public boolean handlePacketReceive(Object packet) {
        boolean canReceive = true;
        for (Connection.PacketReceiveListener listener : this.receiveListeners) {
            try {
                if (listener.onPacketReceiving(packet)) continue;
                canReceive = false;
            }
            catch (Throwable t) {
                System.err.println("Error occured while handling packet receiving");
                t.printStackTrace();
            }
        }
        return canReceive;
    }
}

