/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.commands;

import io.netty.util.ResourceLeakDetector;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.zplatform.ServerPlatform;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("protocolsupport.admin")) {
            sender.sendMessage(ChatColor.RED + "You have no power here!");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            for (ProtocolVersion version : ProtocolVersion.values()) {
                if (version.getName() == null) continue;
                sender.sendMessage(ChatColor.GOLD + "[" + version.getName() + "]: " + ChatColor.GREEN + this.getPlayersStringForProtocol(version));
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("debug")) {
            if (ServerPlatform.get().getMiscUtils().isDebugging()) {
                ServerPlatform.get().getMiscUtils().disableDebug();
                sender.sendMessage(ChatColor.GOLD + "Disabled debug");
            } else {
                ServerPlatform.get().getMiscUtils().enableDebug();
                sender.sendMessage(ChatColor.GOLD + "Enabled debug");
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("leakdetector")) {
            if (ResourceLeakDetector.isEnabled()) {
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
                sender.sendMessage(ChatColor.GOLD + "Disabled leak detector");
            } else {
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
                sender.sendMessage(ChatColor.GOLD + "Enabled leak detector");
            }
            return true;
        }
        return false;
    }

    private String getPlayersStringForProtocol(ProtocolVersion version) {
        StringBuilder sb = new StringBuilder();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (ProtocolSupportAPI.getProtocolVersion(player) != version) continue;
            sb.append(player.getName());
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if ("list".startsWith(args[0])) {
            completions.add("list");
        }
        if ("debug".startsWith(args[0])) {
            completions.add("debug");
        }
        if ("leakdetector".startsWith(args[0])) {
            completions.add("leakdetector");
        }
        return completions;
    }
}

