/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.misc;

import com.lenis0012.bukkit.marriage2.internal.MarriageBase;
import com.lenis0012.bukkit.marriage2.internal.MarriagePlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class BConfig
extends YamlConfiguration {
    private final MarriageBase core;
    private final File file;

    public BConfig(MarriageBase core, File file) {
        this.core = core;
        this.file = file;
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.reload();
    }

    public void reload() {
        try {
            this.load(this.file);
        }
        catch (Exception e) {
            this.core.getLogger().log(Level.WARNING, "Failed to reload configuration file", e);
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (Exception e) {
            this.core.getLogger().log(Level.WARNING, "Failed to save configuration file", e);
        }
    }

    public <T> T getOrDefault(String key, T def) {
        return (T)(this.contains(key) ? this.get(key) : def);
    }

    public <T> T getOrSet(String key, T def) {
        if (this.contains(key)) {
            return (T)this.get(key);
        }
        this.set(key, def);
        return def;
    }

    public <T> T get(String key, Class<T> type) {
        return type.cast(this.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream input, File file) {
        FileOutputStream output = null;
        try {
            int length;
            output = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            MarriagePlugin.getCore().getLogger().log(Level.WARNING, "Failed to copy file", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

