/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.listeners;

import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.config.Settings;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.metadata.MetadataValue;

public class ChatListener
implements Listener {
    private final MarriageCore core;

    public ChatListener(MarriageCore core) {
        this.core = core;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        MPlayer mp = this.core.getMPlayer(player.getUniqueId());
        if (mp.isInChat()) {
            if (!this.isOnline(mp.getPartner())) {
                mp.setInChat(false);
                return;
            }
            event.setCancelled(true);
            String message = Settings.PM_FORMAT.value().replace("{name}", player.getDisplayName()).replace("{message}", event.getMessage()).replace("{heart}", "\u2764");
            message = this.formatIcons(message);
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            Player partner = Bukkit.getPlayer((UUID)mp.getPartner().getUniqueId());
            player.sendMessage(message);
            partner.sendMessage(message);
            String adminMessage = null;
            for (Player admin : Bukkit.getOnlinePlayers()) {
                MPlayer mAdmin;
                if (admin.equals(player) || admin.equals(partner) || !(mAdmin = this.core.getMPlayer(admin.getUniqueId())).isChatSpy()) continue;
                if (adminMessage == null) {
                    adminMessage = Settings.CHATSPY_FORMAT.value().replace("{sender}", player.getDisplayName()).replace("{receiver}", partner.getDisplayName());
                    adminMessage = this.formatIcons(adminMessage);
                    adminMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)adminMessage).replace("{message}", event.getMessage());
                }
                admin.sendMessage(adminMessage);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChatLate(AsyncPlayerChatEvent event) {
        String format = event.getFormat();
        Player player = event.getPlayer();
        MPlayer mplayer = this.core.getMPlayer(player.getUniqueId());
        if (Settings.FORCE_FORMAT.value().booleanValue()) {
            format = "{marriage_status}" + event.getFormat();
        }
        if (format.contains("{marriage_status}")) {
            String status = "";
            if (mplayer.isMarried()) {
                String partner = player.hasMetadata("marriedTo") ? ((MetadataValue)player.getMetadata("marriedTo").get(0)).asString() : "";
                status = Settings.CHAT_FORMAT.value().replace("{heart}", "\u2764").replace("{partner}", partner);
                status = this.formatIcons(status);
                status = ChatColor.translateAlternateColorCodes((char)'&', (String)status);
            }
            event.setFormat(format.replace("{marriage_status}", status));
        }
        if (format.contains("{marriage_gender}")) {
            String gender = mplayer.getGender().getChatPrefix();
            gender = this.formatIcons(gender);
            gender = ChatColor.translateAlternateColorCodes((char)'&', (String)gender);
            event.setFormat(format.replace("{marriage_gender}", gender));
        }
    }

    private String formatIcons(String text) {
        return text.replace("{heart}", "\u2764").replace("{icon:heart}", "\u2764").replace("{icon:male}", "\u2642").replace("{icon:female}", "\u2640").replace("{icon:genderless}", "\u26b2");
    }

    private boolean isOnline(MPlayer mp) {
        if (mp == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)mp.getUniqueId());
        return player != null && player.isOnline();
    }
}

