/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal.data;

import com.lenis0012.bukkit.marriage2.Gender;
import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.config.Settings;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.MarriagePlugin;
import com.lenis0012.bukkit.marriage2.internal.data.MarriageData;
import com.lenis0012.bukkit.marriage2.misc.Cooldown;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MarriagePlayer
implements MPlayer {
    private final Cooldown<UUID> requests;
    private final UUID uuid;
    private String lastName;
    private MData marriage;
    private Gender gender = Gender.UNKNOWN;
    private boolean inChat;
    private boolean chatSpy;
    private boolean priest;
    private long lastLogin;
    private long lastLogout;

    public MarriagePlayer(UUID uuid, ResultSet data) throws SQLException {
        this.uuid = uuid;
        if (data.next()) {
            this.lastName = data.getString("last_name");
            this.gender = Gender.valueOf(data.getString("gender"));
            this.priest = data.getBoolean("priest");
            this.lastLogout = data.getLong("lastlogin");
        }
        this.lastLogin = System.currentTimeMillis();
        this.requests = new Cooldown(Settings.REQUEST_EXPRY.value().intValue(), TimeUnit.SECONDS);
    }

    public void addMarriage(MarriageData data) {
        this.marriage = data;
    }

    void save(PreparedStatement ps) throws SQLException {
        ps.setString(1, this.uuid.toString());
        ps.setString(2, this.lastName);
        ps.setString(3, this.gender.toString());
        ps.setBoolean(4, this.priest);
        ps.setLong(5, System.currentTimeMillis());
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String name) {
        this.lastName = name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public void requestMarriage(UUID from) {
        this.requests.set(from);
    }

    @Override
    public boolean isMarriageRequested(UUID from) {
        return this.requests.isCached(from);
    }

    @Override
    public Gender getGender() {
        return this.gender;
    }

    @Override
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Override
    public MData getMarriage() {
        return this.marriage;
    }

    @Override
    public boolean isMarried() {
        return this.marriage != null;
    }

    @Override
    public boolean isInChat() {
        return this.inChat;
    }

    @Override
    public void setInChat(boolean inChat) {
        this.inChat = inChat;
    }

    @Override
    public MPlayer getPartner() {
        Marriage core = MarriagePlugin.getCore();
        if (this.marriage != null) {
            UUID id = this.uuid.equals(this.marriage.getPlayer1Id()) ? this.marriage.getPllayer2Id() : this.marriage.getPlayer1Id();
            return core.getMPlayer(id);
        }
        return null;
    }

    @Override
    public void divorce() {
        if (this.marriage == null) {
            return;
        }
        ((MarriageCore)MarriagePlugin.getCore()).removeMarriage(this.marriage);
        MarriagePlayer partner = (MarriagePlayer)this.getPartner();
        partner.marriage = null;
        this.marriage = null;
    }

    @Override
    public boolean isPriest() {
        return this.priest;
    }

    @Override
    public void setPriest(boolean priest) {
        this.priest = priest;
    }

    @Override
    public long getLastLogin() {
        return this.lastLogin;
    }

    @Override
    public long getLastLogout() {
        return this.lastLogout;
    }

    @Override
    public boolean isChatSpy() {
        return this.chatSpy;
    }

    @Override
    public void setChatSpy(boolean chatSpy) {
        this.chatSpy = chatSpy;
    }
}

