/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.privatemessages;

import br.com.devpaulo.legendchat.afk.AfkManager;
import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.api.events.PrivateMessageEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PrivateMessageManager {
    private final HashMap<CommandSender, CommandSender> telling = new HashMap();
    private final HashMap<CommandSender, CommandSender> reply = new HashMap();
    private final CommandSender console = Bukkit.getConsoleSender();

    public void tellPlayer(CommandSender from, CommandSender to, String msg) {
        if (to == null) {
            if (!this.isPlayerTellLocked(from)) {
                return;
            }
            to = this.telling.get(from);
        }
        AfkManager afk = Legendchat.getAfkManager();
        if (from != this.console) {
            afk.removeAfk((Player)from);
        }
        if (to != this.console && afk.isAfk((Player)to)) {
            from.sendMessage(Legendchat.getMessageManager().getMessage("pm_error2_1"));
            String mot = afk.getPlayerAfkMotive((Player)to);
            if (mot != null) {
                from.sendMessage(Legendchat.getMessageManager().getMessage("pm_error2_2").replace("@motive", mot));
            }
            return;
        }
        PrivateMessageEvent e = new PrivateMessageEvent(from, to, msg);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        from = e.getSender();
        to = e.getReceiver();
        msg = e.getMessage();
        if (Legendchat.isCensorActive()) {
            msg = Legendchat.getCensorManager().censorFunction(msg);
        }
        boolean ignored = false;
        if (to != this.console && from != this.console && Legendchat.getIgnoreManager().hasPlayerIgnoredPlayer((Player)to, from.getName())) {
            ignored = true;
        }
        if (!ignored) {
            this.setPlayerReply(to, from);
        }
        from.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Legendchat.getPrivateMessageFormat("send")).replace("{sender}", from.getName()).replace("{receiver}", to.getName()).replace("{msg}", msg));
        if (!ignored) {
            to.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Legendchat.getPrivateMessageFormat("receive")).replace("{sender}", from.getName()).replace("{receiver}", to.getName()).replace("{msg}", msg));
        }
        String spy = ChatColor.translateAlternateColorCodes((char)'&', (String)Legendchat.getPrivateMessageFormat("spy").replace("{sender}", from.getName()).replace("{receiver}", to.getName()).replace("{ignored}", ignored ? Legendchat.getMessageManager().getMessage("ignored") : "")).replace("{msg}", msg);
        for (Player p : Legendchat.getPlayerManager().getOnlineSpys()) {
            if ((p == from || p == to) && (!ignored || p != to)) continue;
            p.sendMessage(spy);
        }
        if (Legendchat.logToBukkit()) {
            Bukkit.getConsoleSender().sendMessage(spy);
        }
        if (Legendchat.logToFile()) {
            Legendchat.getLogManager().addLogToCache(ChatColor.stripColor((String)spy));
        }
    }

    public void replyPlayer(CommandSender from, String msg) {
        if (!this.playerHasReply(from)) {
            from.sendMessage(Legendchat.getMessageManager().getMessage("pm_error1"));
            return;
        }
        this.tellPlayer(from, this.getPlayerReply(from), msg);
    }

    public void lockPlayerTell(CommandSender from, CommandSender to) {
        this.unlockPlayerTell(from);
        this.telling.put(from, to);
    }

    public void unlockPlayerTell(CommandSender p) {
        if (this.isPlayerTellLocked(p)) {
            this.telling.remove(p);
        }
    }

    public boolean isPlayerTellLocked(CommandSender p) {
        return this.telling.containsKey(p);
    }

    public CommandSender getPlayerLockedTellWith(CommandSender p) {
        if (this.isPlayerTellLocked(p)) {
            return this.telling.get(p);
        }
        return null;
    }

    public List<CommandSender> getAllTellLockedPlayers() {
        ArrayList<CommandSender> l = new ArrayList<CommandSender>();
        l.addAll(this.telling.keySet());
        return l;
    }

    public void setPlayerReply(CommandSender to, CommandSender from) {
        if (this.playerHasReply(to)) {
            this.reply.remove(to);
        }
        this.reply.put(to, from);
    }

    public CommandSender getPlayerReply(CommandSender p) {
        if (!this.playerHasReply(p)) {
            return null;
        }
        return this.reply.get(p);
    }

    public boolean playerHasReply(CommandSender p) {
        return this.reply.containsKey(p);
    }

    public List<CommandSender> getAllPlayersWithReply() {
        ArrayList<CommandSender> l = new ArrayList<CommandSender>();
        l.addAll(this.reply.keySet());
        return l;
    }

    public void playerDisconnect(CommandSender p) {
        this.unlockPlayerTell(p);
        if (this.reply.containsKey(p)) {
            this.reply.remove(p);
        }
        ArrayList<CommandSender> lista = new ArrayList<CommandSender>();
        for (CommandSender p2 : this.getAllTellLockedPlayers()) {
            if (this.telling.get(p2) != p) continue;
            lista.add(p2);
        }
        for (CommandSender p3 : lista) {
            this.telling.remove(p3);
        }
        lista.clear();
        for (CommandSender p2 : this.getAllPlayersWithReply()) {
            if (this.reply.get(p2) != p) continue;
            lista.add(p2);
        }
        for (CommandSender p3 : lista) {
            this.reply.remove(p3);
        }
    }
}

