/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.configurations;

import br.com.devpaulo.legendchat.api.Legendchat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class TemporaryChannelConfig {
    private String format = "";
    private String color = "";
    private String color2 = "";
    private boolean shortcut = false;
    private boolean focus = false;
    private double distance = 0.0;
    private boolean crossworlds = false;
    private double cost = 0.0;
    private boolean show_cost_msg = false;
    private int delay = 0;
    private int max_joins = 0;
    private int max_admin = 0;
    private int max_joins_c = 0;
    private int max_mods = 0;
    private int max_name_size = 15;
    private int max_nick_size = 5;
    private boolean mod_can_kick = false;
    private boolean mod_can_invite = false;
    private boolean enabled = true;
    private final List<String> blocked_names = new ArrayList<String>();
    private final List<String> blocked_colors = new ArrayList<String>();

    public boolean isTemporaryChannelsEnabled() {
        return this.enabled;
    }

    public String getFormat() {
        return this.format;
    }

    public String getColor() {
        return this.color;
    }

    public String getStringColor() {
        return this.color2;
    }

    public boolean isShortcutAllowed() {
        return this.shortcut;
    }

    public boolean isFocusNeeded() {
        return this.focus;
    }

    public boolean isCrossworlds() {
        return this.crossworlds;
    }

    public double getMaxDistance() {
        return this.distance;
    }

    public double getMessageCost() {
        return this.cost;
    }

    public double getCostPerMessage() {
        return this.cost;
    }

    public boolean showCostMessage() {
        return this.show_cost_msg;
    }

    public int getDelayPerMessage() {
        return this.delay;
    }

    public int getMaxJoinsPerPlayer() {
        return this.max_joins;
    }

    public int getMaxAdminPerPlayer() {
        return this.max_admin;
    }

    public int getMaxJoinsPerChannel() {
        return this.max_joins_c;
    }

    public int getMaxModeratorsPerChannel() {
        return this.max_mods;
    }

    public boolean moderatorsCanKick() {
        return this.mod_can_kick;
    }

    public boolean moderatorsCanInvite() {
        return this.mod_can_invite;
    }

    public int getMaxChannelNameLength() {
        return this.max_name_size;
    }

    public int getMaxChannelNicknameLength() {
        return this.max_nick_size;
    }

    public List<String> getBlockedNames() {
        return this.blocked_names;
    }

    public List<String> getBlockedColors() {
        return this.blocked_colors;
    }

    public void loadConfig() {
        File f = new File(Legendchat.getPlugin().getDataFolder(), "temporary_channels.yml");
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)f);
        this.enabled = c.getBoolean("enabled");
        this.format = c.getString("format");
        String color3 = c.getString("color");
        this.color = this.translateStringColor(color3);
        this.color2 = color3.toLowerCase();
        this.shortcut = c.getBoolean("shortcutAllowed");
        this.focus = c.getBoolean("needFocus");
        this.distance = c.getDouble("distance");
        this.crossworlds = c.getBoolean("crossworlds");
        this.cost = c.getDouble("costPerMessage");
        this.show_cost_msg = c.getBoolean("showCostMessage");
        this.delay = c.getInt("delayPerMessage");
        this.max_joins = c.getInt("maxJoinsPerPlayer");
        this.max_admin = c.getInt("maxAdminPerPlayer");
        this.max_joins_c = c.getInt("maxJoinsPerChannel");
        this.max_mods = c.getInt("maxModeratorsPerChannel");
        this.mod_can_kick = c.getBoolean("moderator.canKick");
        this.mod_can_invite = c.getBoolean("moderator.canInvite");
        this.max_name_size = c.getInt("maxChannelNameLength");
        this.max_nick_size = c.getInt("maxChannelNicknameLength");
        this.blocked_names.clear();
        for (String n : c.getStringList("blocked_names")) {
            this.blocked_names.add(n.toLowerCase());
        }
        this.blocked_colors.clear();
        for (String n : c.getStringList("blocked_colors")) {
            this.blocked_colors.add(n.toLowerCase());
        }
    }

    private String translateStringColor(String color) {
        switch (color.toLowerCase()) {
            case "black": {
                return "\ufffd0";
            }
            case "darkblue": {
                return "\ufffd1";
            }
            case "darkgreen": {
                return "\ufffd2";
            }
            case "darkaqua": {
                return "\ufffd3";
            }
            case "darkred": {
                return "\ufffd4";
            }
            case "darkpurple": {
                return "\ufffd5";
            }
            case "gold": {
                return "\ufffd6";
            }
            case "gray": {
                return "\ufffd7";
            }
            case "darkgray": {
                return "\ufffd8";
            }
            case "blue": {
                return "\ufffd9";
            }
            case "green": {
                return "\ufffda";
            }
            case "aqua": {
                return "\ufffdb";
            }
            case "red": {
                return "\ufffdc";
            }
            case "lightpurple": {
                return "\ufffdd";
            }
            case "yellow": {
                return "\ufffde";
            }
        }
        return "\ufffdf";
    }
}

