/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.itemstack;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.server.v1_11_R1.MojangsonParseException;
import net.minecraft.server.v1_11_R1.MojangsonParser;
import net.minecraft.server.v1_11_R1.NBTBase;
import net.minecraft.server.v1_11_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_11_R1.NBTReadLimiter;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import org.spigotmc.SneakyThrow;
import protocolsupport.zplatform.impl.spigot.itemstack.SpigotNBTTagListWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.NBTTagListWrapper;

public class SpigotNBTTagCompoundWrapper
extends NBTTagCompoundWrapper {
    protected final NBTTagCompound tag;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_COMPOUND = 10;
    public static final int TYPE_LIST = 9;

    protected SpigotNBTTagCompoundWrapper(NBTTagCompound tag) {
        this.tag = tag;
    }

    public final NBTTagCompound unwrap() {
        return this.tag;
    }

    public static NBTTagCompoundWrapper fromJson(String json) {
        try {
            return new SpigotNBTTagCompoundWrapper(MojangsonParser.parse((String)json));
        }
        catch (MojangsonParseException e) {
            SneakyThrow.sneaky((Throwable)e);
            return null;
        }
    }

    public static SpigotNBTTagCompoundWrapper fromStream(DataInput datainput) throws IOException {
        return new SpigotNBTTagCompoundWrapper(NBTCompressedStreamTools.a((DataInput)datainput, (NBTReadLimiter)new NBTReadLimiter(0x200000L)));
    }

    public static SpigotNBTTagCompoundWrapper createEmpty() {
        return new SpigotNBTTagCompoundWrapper(new NBTTagCompound());
    }

    public static SpigotNBTTagCompoundWrapper createNull() {
        return new SpigotNBTTagCompoundWrapper(null);
    }

    public static SpigotNBTTagCompoundWrapper wrap(NBTTagCompound tag) {
        return new SpigotNBTTagCompoundWrapper(tag);
    }

    @Override
    public void writeToStream(OutputStream outputstream) throws IOException {
        NBTCompressedStreamTools.a((NBTTagCompound)this.tag, (DataOutput)new DataOutputStream(outputstream));
    }

    @Override
    public boolean isNull() {
        return this.tag == null;
    }

    @Override
    public void remove(String key) {
        this.tag.remove(key);
    }

    @Override
    public Collection<String> getKeys() {
        return this.tag.c();
    }

    @Override
    public boolean hasKeyOfType(String tagname, int i) {
        return this.tag.hasKeyOfType(tagname, i);
    }

    @Override
    public NBTTagCompoundWrapper getCompound(String key) {
        return new SpigotNBTTagCompoundWrapper(this.tag.getCompound(key));
    }

    @Override
    public void setCompound(String key, NBTTagCompoundWrapper compound) {
        this.tag.set(key, (NBTBase)((SpigotNBTTagCompoundWrapper)compound).tag);
    }

    @Override
    public NBTTagListWrapper getList(String key, int type) {
        return new SpigotNBTTagListWrapper(this.tag.getList(key, type));
    }

    @Override
    public void setList(String key, NBTTagListWrapper list) {
        this.tag.set(key, (NBTBase)((SpigotNBTTagListWrapper)list).tag);
    }

    @Override
    public String getString(String key) {
        return this.tag.getString(key);
    }

    @Override
    public void setString(String key, String value) {
        this.tag.setString(key, value);
    }

    @Override
    public int getNumber(String key) {
        return this.tag.getInt(key);
    }

    @Override
    public void setInt(String key, int i) {
        this.tag.setInt(key, i);
    }

    @Override
    public void setByte(String key, int value) {
        this.tag.setByte(key, (byte)value);
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof SpigotNBTTagCompoundWrapper)) {
            return false;
        }
        SpigotNBTTagCompoundWrapper other = (SpigotNBTTagCompoundWrapper)otherObj;
        return Objects.equals(this.tag, other.tag);
    }

    public String toString() {
        return Objects.toString(this.tag);
    }
}

