/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot;

import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import net.minecraft.server.v1_11_R1.EnumProtocol;
import net.minecraft.server.v1_11_R1.MinecraftServer;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import net.minecraft.server.v1_11_R1.NetworkManager;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_11_R1.CraftServer;
import org.bukkit.craftbukkit.v1_11_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_11_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_11_R1.util.CraftIconCache;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.CachedServerIcon;
import org.spigotmc.SpigotConfig;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.protocol.pipeline.IPacketPrepender;
import protocolsupport.protocol.pipeline.IPacketSplitter;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.zplatform.PlatformUtils;
import protocolsupport.zplatform.impl.spigot.itemstack.SpigotNBTTagCompoundWrapper;
import protocolsupport.zplatform.impl.spigot.network.SpigotNetworkManagerWrapper;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotWrappedPrepender;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotWrappedSplitter;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public class SpigotMiscUtils
implements PlatformUtils {
    public static NetworkState netStateFromEnumProtocol(EnumProtocol state) {
        switch (state) {
            case HANDSHAKING: {
                return NetworkState.HANDSHAKING;
            }
            case PLAY: {
                return NetworkState.PLAY;
            }
            case LOGIN: {
                return NetworkState.LOGIN;
            }
            case STATUS: {
                return NetworkState.STATUS;
            }
        }
        throw new IllegalArgumentException("Unknown state " + state);
    }

    public static MinecraftServer getServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public static com.mojang.authlib.GameProfile toMojangGameProfile(GameProfile profile) {
        com.mojang.authlib.GameProfile mojangGameProfile = new com.mojang.authlib.GameProfile(profile.getUUID(), profile.getName());
        for (Map.Entry<String, PlayerPropertiesResolveEvent.ProfileProperty> entry : profile.getProperties().entrySet()) {
            PlayerPropertiesResolveEvent.ProfileProperty property = entry.getValue();
            mojangGameProfile.getProperties().put((Object)entry.getKey(), (Object)new Property(property.getName(), property.getValue(), property.getSignature()));
        }
        return mojangGameProfile;
    }

    @Override
    public ItemStack createItemStackFromNBTTag(NBTTagCompoundWrapper tag) {
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_11_R1.ItemStack)new net.minecraft.server.v1_11_R1.ItemStack(((SpigotNBTTagCompoundWrapper)tag).unwrap()));
    }

    @Override
    public NBTTagCompoundWrapper createNBTTagFromItemStack(ItemStack itemstack) {
        net.minecraft.server.v1_11_R1.ItemStack nmsitemstack = CraftItemStack.asNMSCopy((ItemStack)itemstack);
        NBTTagCompound compound = new NBTTagCompound();
        nmsitemstack.save(compound);
        return SpigotNBTTagCompoundWrapper.wrap(compound);
    }

    @Override
    public String getOutdatedServerMessage() {
        return SpigotConfig.outdatedServerMessage;
    }

    @Override
    public boolean isBungeeEnabled() {
        return SpigotConfig.bungee;
    }

    @Override
    public boolean isDebugging() {
        return SpigotMiscUtils.getServer().isDebugging();
    }

    @Override
    public void enableDebug() {
        SpigotMiscUtils.getServer().getPropertyManager().setProperty("debug", (Object)Boolean.TRUE);
    }

    @Override
    public void disableDebug() {
        SpigotMiscUtils.getServer().getPropertyManager().setProperty("debug", (Object)Boolean.FALSE);
    }

    @Override
    public int getCompressionThreshold() {
        return SpigotMiscUtils.getServer().aG();
    }

    @Override
    public KeyPair getEncryptionKeyPair() {
        return SpigotMiscUtils.getServer().O();
    }

    @Override
    public <V> FutureTask<V> callSyncTask(Callable<V> call) {
        FutureTask<V> task = new FutureTask<V>(call);
        SpigotMiscUtils.getServer().processQueue.add(task);
        return task;
    }

    @Override
    public String getModName() {
        return SpigotMiscUtils.getServer().getServerModName();
    }

    @Override
    public String getVersionName() {
        return SpigotMiscUtils.getServer().getVersion();
    }

    @Override
    public Statistic getStatisticByName(String value) {
        return CraftStatistic.getBukkitStatisticByName((String)value);
    }

    @Override
    public String getStatisticName(Statistic stat) {
        return CraftStatistic.getNMSStatistic((Statistic)stat).name;
    }

    @Override
    public Achievement getAchievmentByName(String value) {
        return CraftStatistic.getBukkitAchievementByName((String)value);
    }

    @Override
    public String getAchievmentName(Achievement achievement) {
        return CraftStatistic.getNMSAchievement((Achievement)achievement).name;
    }

    @Override
    public String convertBukkitIconToBase64(CachedServerIcon icon) {
        if (icon == null) {
            return null;
        }
        if (!(icon instanceof CraftIconCache)) {
            throw new IllegalArgumentException(icon + " was not created by " + CraftServer.class);
        }
        return ((CraftIconCache)icon).value;
    }

    @Override
    public NetworkState getNetworkStateFromChannel(Channel channel) {
        return SpigotMiscUtils.netStateFromEnumProtocol((EnumProtocol)channel.attr(NetworkManager.c).get());
    }

    @Override
    public NetworkManagerWrapper getNetworkManagerFromChannel(Channel channel) {
        return SpigotNetworkManagerWrapper.getFromChannel(channel);
    }

    @Override
    public String getReadTimeoutHandlerName() {
        return "timeout";
    }

    @Override
    public String getSplitterHandlerName() {
        return "splitter";
    }

    @Override
    public String getPrependerHandlerName() {
        return "prepender";
    }

    @Override
    public void setFraming(ChannelPipeline pipeline, IPacketSplitter splitter, IPacketPrepender prepender) {
        ((SpigotWrappedSplitter)pipeline.get("splitter")).setRealSplitter(splitter);
        ((SpigotWrappedPrepender)pipeline.get("prepender")).setRealPrepender(prepender);
    }
}

