/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.itemstack;

import java.util.Collections;
import java.util.Objects;
import net.glowstone.util.nbt.ByteTag;
import net.glowstone.util.nbt.CompoundTag;
import net.glowstone.util.nbt.IntTag;
import net.glowstone.util.nbt.ListTag;
import net.glowstone.util.nbt.StringTag;
import net.glowstone.util.nbt.Tag;
import net.glowstone.util.nbt.TagType;
import protocolsupport.zplatform.impl.glowstone.itemstack.GlowStoneNBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.NBTTagListWrapper;

public class GlowStoneNBTTagListWrapper
extends NBTTagListWrapper {
    protected final ListTag<Tag<?>> tag;

    protected GlowStoneNBTTagListWrapper(ListTag<Tag<?>> tag) {
        this.tag = tag;
    }

    public static GlowStoneNBTTagListWrapper create() {
        return new GlowStoneNBTTagListWrapper(new ListTag(null, Collections.emptyList()));
    }

    @Override
    public boolean isEmpty() {
        return this.tag.getValue().isEmpty();
    }

    @Override
    public int size() {
        return this.tag.getValue().size();
    }

    private boolean checkIndex(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public NBTTagCompoundWrapper getCompound(int index) {
        if (this.tag.getType() == TagType.COMPOUND && this.checkIndex(index)) {
            return GlowStoneNBTTagCompoundWrapper.wrap((CompoundTag)this.tag.getValue().get(index));
        }
        return GlowStoneNBTTagCompoundWrapper.createEmpty();
    }

    @Override
    public void addCompound(NBTTagCompoundWrapper wrapper) {
        if (this.tag.getType() == TagType.COMPOUND) {
            this.tag.getValue().add(((GlowStoneNBTTagCompoundWrapper)wrapper).tag);
        }
    }

    @Override
    public String getString(int index) {
        if (this.tag.getType() == TagType.STRING && this.checkIndex(index)) {
            return ((StringTag)this.tag.getValue().get(index)).getValue();
        }
        return "";
    }

    @Override
    public void addString(String value) {
        if (this.tag.getType() == TagType.STRING) {
            this.tag.getValue().add(new StringTag(value));
        }
    }

    @Override
    public int getNumber(int index) {
        Object value;
        if (this.checkIndex(index) && (value = ((Tag)this.tag.getValue().get(index)).getValue()) instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    @Override
    public void addInt(int i) {
        if (this.tag.getType() == TagType.INT) {
            this.tag.getValue().add(new IntTag(i));
        }
    }

    @Override
    public void addByte(int b) {
        if (this.tag.getType() == TagType.BYTE) {
            this.tag.getValue().add(new ByteTag((byte)b));
        }
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof GlowStoneNBTTagListWrapper)) {
            return false;
        }
        GlowStoneNBTTagListWrapper other = (GlowStoneNBTTagListWrapper)otherObj;
        return Objects.equals(this.tag, other.tag);
    }

    public String toString() {
        return this.tag.toString();
    }
}

