/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform;

import net.glowstone.GlowServer;
import net.minecraft.server.v1_11_R1.NetworkManager;
import org.spigotmc.SpigotConfig;
import protocolsupport.zplatform.PlatformInjector;
import protocolsupport.zplatform.PlatformPacketFactory;
import protocolsupport.zplatform.PlatformUtils;
import protocolsupport.zplatform.PlatformWrapperFactory;
import protocolsupport.zplatform.impl.glowstone.GlowStoneMiscUtils;
import protocolsupport.zplatform.impl.glowstone.GlowStonePacketFactory;
import protocolsupport.zplatform.impl.glowstone.GlowStoneWrapperFactory;
import protocolsupport.zplatform.impl.glowstone.injector.GlowstonePlatformInjector;
import protocolsupport.zplatform.impl.spigot.SpigotMiscUtils;
import protocolsupport.zplatform.impl.spigot.SpigotPacketFactory;
import protocolsupport.zplatform.impl.spigot.SpigotWrapperFactory;
import protocolsupport.zplatform.impl.spigot.injector.SpigotPlatformInjector;

public class ServerPlatform {
    private static ServerPlatform current;
    private final String name;
    private final PlatformInjector injector;
    private final PlatformUtils utils;
    private final PlatformPacketFactory packetfactory;
    private final PlatformWrapperFactory wrapperfactory;

    public static boolean detect() {
        if (current != null) {
            throw new IllegalStateException("Implementation already detected");
        }
        try {
            NetworkManager.class.getDeclaredFields();
            SpigotConfig.class.getDeclaredFields();
            current = new ServerPlatform("Spigot", new SpigotPlatformInjector(), new SpigotMiscUtils(), new SpigotPacketFactory(), new SpigotWrapperFactory());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            GlowServer.class.getDeclaredFields();
            current = new ServerPlatform("GlowStone", new GlowstonePlatformInjector(), new GlowStoneMiscUtils(), new GlowStonePacketFactory(), new GlowStoneWrapperFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return current != null;
    }

    public static ServerPlatform get() {
        if (current == null) {
            throw new IllegalStateException("Access to implementation before detect");
        }
        return current;
    }

    private ServerPlatform(String name, PlatformInjector injector, PlatformUtils miscutils, PlatformPacketFactory packetfactory, PlatformWrapperFactory wrapperfactory) {
        this.name = name;
        this.injector = injector;
        this.utils = miscutils;
        this.packetfactory = packetfactory;
        this.wrapperfactory = wrapperfactory;
    }

    public String getName() {
        return this.name;
    }

    public void inject() {
        this.injector.inject();
    }

    public PlatformUtils getMiscUtils() {
        return this.utils;
    }

    public PlatformPacketFactory getPacketFactory() {
        return this.packetfactory;
    }

    public PlatformWrapperFactory getWrapperFactory() {
        return this.wrapperfactory;
    }
}

