/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.authlib;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;

public class GameProfile {
    private final UUID uuid;
    private final String name;
    private final HashMap<String, PlayerPropertiesResolveEvent.ProfileProperty> properties = new HashMap();

    public GameProfile(UUID uuid, String name) {
        if (uuid == null && name == null) {
            throw new IllegalArgumentException("Both name and uuid can't be null");
        }
        this.uuid = uuid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Map<String, PlayerPropertiesResolveEvent.ProfileProperty> getProperties() {
        return new HashMap<String, PlayerPropertiesResolveEvent.ProfileProperty>(this.properties);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public void addProperty(PlayerPropertiesResolveEvent.ProfileProperty property) {
        this.properties.put(property.getName(), property);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public String toString() {
        return MessageFormat.format("GameProfile(id={0},name={1})", this.uuid, this.name);
    }
}

