/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.itemstack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.bukkit.Material;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.api.remapper.BlockRemapperControl;
import protocolsupport.libs.gnu.trove.decorator.TIntObjectMapDecorator;
import protocolsupport.libs.gnu.trove.map.hash.TIntObjectHashMap;
import protocolsupport.protocol.typeremapper.id.RemappingRegistry;
import protocolsupport.protocol.typeremapper.id.RemappingTable;
import protocolsupport.protocol.typeremapper.itemstack.ItemStackSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.BookPagesToLegacyTextSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.DragonHeadSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.EmptyBookPageAdderSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.EnchantFilterNBTSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.MonsterEggToLegacyIdSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.MonsterEggToLegacyNameSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.PlayerSkullSpecificRemapper;
import protocolsupport.protocol.typeremapper.itemstack.clientbound.PotionToLegacyIdSpecificRemapper;
import protocolsupport.protocol.utils.GameProfileSerializer;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.protocol.utils.authlib.UUIDTypeAdapter;
import protocolsupport.utils.ProtocolVersionsHelper;
import protocolsupport.utils.Utils;
import protocolsupport.zplatform.itemstack.ItemStackWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class ItemStackRemapper {
    public static final RemappingRegistry.IdRemappingRegistry<RemappingTable.ArrayBasedIdRemappingTable> ITEM_ID_REMAPPING_REGISTRY = new RemappingRegistry.IdRemappingRegistry<RemappingTable.ArrayBasedIdRemappingTable>(){
        {
            for (ProtocolVersion version : ProtocolVersion.values()) {
                if (!version.isSupported()) continue;
                BlockRemapperControl ctrl = ProtocolSupportAPI.getBlockRemapper(version);
                for (int i = 0; i < 4096; ++i) {
                    this.registerRemapEntry(i, ctrl.getRemap(i), version);
                }
            }
            this.registerRemapEntry(Material.SHULKER_SHELL, Material.COBBLESTONE, ProtocolVersionsHelper.BEFORE_1_11);
            this.registerRemapEntry(Material.TOTEM, Material.COBBLESTONE, ProtocolVersionsHelper.BEFORE_1_11);
            this.registerRemapEntry(Material.BEETROOT, Material.BROWN_MUSHROOM, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BEETROOT_SOUP, Material.MUSHROOM_SOUP, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BEETROOT_SEEDS, Material.SEEDS, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.CHORUS_FRUIT, Material.POTATO_ITEM, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.CHORUS_FRUIT_POPPED, Material.BAKED_POTATO, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.DRAGONS_BREATH, Material.POTION, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.SPLASH_POTION, Material.POTION, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.LINGERING_POTION, Material.POTION, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.ELYTRA, Material.LEATHER_CHESTPLATE, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.END_CRYSTAL, Material.STONE, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.SHIELD, Material.WOOD_SWORD, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.SPECTRAL_ARROW, Material.ARROW, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.TIPPED_ARROW, Material.ARROW, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BOAT_ACACIA, Material.BOAT, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BOAT_BIRCH, Material.BOAT, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BOAT_DARK_OAK, Material.BOAT, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BOAT_JUNGLE, Material.BOAT, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(Material.BOAT_SPRUCE, Material.BOAT, ProtocolVersionsHelper.BEFORE_1_9);
            this.registerRemapEntry(427, 324, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(428, 324, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(429, 324, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(430, 324, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(431, 324, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(411, 365, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(412, 366, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(413, 282, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(423, 365, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(424, 366, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(425, 323, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(409, 1, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(410, 1, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(414, 1, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(415, 1, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(416, 1, ProtocolVersionsHelper.BEFORE_1_8);
            this.registerRemapEntry(417, 1, ProtocolVersionsHelper.BEFORE_1_6);
            this.registerRemapEntry(418, 1, ProtocolVersionsHelper.BEFORE_1_6);
            this.registerRemapEntry(419, 1, ProtocolVersionsHelper.BEFORE_1_6);
            this.registerRemapEntry(420, 1, ProtocolVersionsHelper.BEFORE_1_6);
            this.registerRemapEntry(421, 1, ProtocolVersionsHelper.BEFORE_1_6);
            this.registerRemapEntry(407, 328, ProtocolVersionsHelper.BEFORE_1_5);
            this.registerRemapEntry(408, 328, ProtocolVersionsHelper.BEFORE_1_5);
            this.registerRemapEntry(404, 356, ProtocolVersionsHelper.BEFORE_1_5);
            this.registerRemapEntry(405, 336, ProtocolVersionsHelper.BEFORE_1_5);
            this.registerRemapEntry(406, 288, ProtocolVersionsHelper.BEFORE_1_5);
        }

        private void registerRemapEntry(Material from, Material to, ProtocolVersion ... versions) {
            this.registerRemapEntry(from.getId(), to.getId(), versions);
        }

        @Override
        protected RemappingTable.ArrayBasedIdRemappingTable createTable() {
            return new RemappingTable.ArrayBasedIdRemappingTable(4096);
        }
    };
    private static final TIntObjectHashMap<EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>>> clientbound_remapper_registry = new TIntObjectHashMap();
    private static final TIntObjectHashMap<EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>>> serverbound_remapper_registry = new TIntObjectHashMap();
    private static final GameProfile dragonHeadGameProfile;

    private static void registerClientboundRemapper(Material material, ItemStackSpecificRemapper transformer, ProtocolVersion ... versions) {
        ItemStackRemapper.registerRemapper(clientbound_remapper_registry, material, transformer, versions);
    }

    private static void registerRemapper(TIntObjectHashMap<EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>>> registry, Material material, ItemStackSpecificRemapper transformer, ProtocolVersion ... versions) {
        EnumMap map = Utils.getOrCreateDefault(new TIntObjectMapDecorator<EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>>>(clientbound_remapper_registry), material.getId(), new EnumMap(ProtocolVersion.class));
        Arrays.stream(versions).forEach(version -> ((List)Utils.getOrCreateDefault(map, version, new ArrayList())).add(transformer));
    }

    public static ItemStackWrapper remapClientbound(ProtocolVersion version, ItemStackWrapper itemstack) {
        return ItemStackRemapper.remap(clientbound_remapper_registry, version, itemstack);
    }

    public static ItemStackWrapper remapServerbound(ProtocolVersion version, ItemStackWrapper itemstack) {
        return ItemStackRemapper.remap(serverbound_remapper_registry, version, itemstack);
    }

    private static ItemStackWrapper remap(TIntObjectHashMap<EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>>> registry, ProtocolVersion version, ItemStackWrapper itemstack) {
        List<ItemStackSpecificRemapper> transformers;
        EnumMap<ProtocolVersion, List<ItemStackSpecificRemapper>> map = registry.get(itemstack.getTypeId());
        if (map != null && (transformers = map.get((Object)version)) != null) {
            for (ItemStackSpecificRemapper transformer : transformers) {
                itemstack = transformer.remap(version, itemstack);
            }
            return itemstack;
        }
        return itemstack;
    }

    public static NBTTagCompoundWrapper createDragonHeadSkullTag() {
        return GameProfileSerializer.serialize(dragonHeadGameProfile);
    }

    public static void remapSkull(NBTTagCompoundWrapper nbttagcompound) {
        ItemStackRemapper.remapSkull(nbttagcompound, "SkullOwner", "SkullOwner");
        ItemStackRemapper.remapSkull(nbttagcompound, "Owner", "ExtraType");
    }

    private static void remapSkull(NBTTagCompoundWrapper tag, String tagname, String newtagname) {
        if (tag.hasKeyOfType(tagname, 10)) {
            GameProfile gameprofile = GameProfileSerializer.deserialize(tag.getCompound(tagname));
            if (gameprofile.getName() != null) {
                tag.setString(newtagname, gameprofile.getName());
            } else {
                tag.remove(tagname);
            }
        }
    }

    static {
        ItemStackRemapper.registerClientboundRemapper(Material.MONSTER_EGG, new MonsterEggToLegacyNameSpecificRemapper(), ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_10, ProtocolVersion.MINECRAFT_1_9));
        ItemStackRemapper.registerClientboundRemapper(Material.MONSTER_EGG, new MonsterEggToLegacyIdSpecificRemapper(), ProtocolVersionsHelper.BEFORE_1_9);
        ItemStackRemapper.registerClientboundRemapper(Material.SKULL_ITEM, new DragonHeadSpecificRemapper(), ProtocolVersionsHelper.BEFORE_1_9);
        ItemStackRemapper.registerClientboundRemapper(Material.SKULL_ITEM, new PlayerSkullSpecificRemapper(), ProtocolVersion.getAllBefore(ProtocolVersion.MINECRAFT_1_7_5));
        ItemStackRemapper.registerClientboundRemapper(Material.POTION, new PotionToLegacyIdSpecificRemapper(false), ProtocolVersionsHelper.BEFORE_1_9);
        ItemStackRemapper.registerClientboundRemapper(Material.SPLASH_POTION, new PotionToLegacyIdSpecificRemapper(true), ProtocolVersionsHelper.BEFORE_1_9);
        ItemStackRemapper.registerClientboundRemapper(Material.LINGERING_POTION, new PotionToLegacyIdSpecificRemapper(true), ProtocolVersionsHelper.BEFORE_1_9);
        ItemStackRemapper.registerClientboundRemapper(Material.WRITTEN_BOOK, new BookPagesToLegacyTextSpecificRemapper(), ProtocolVersionsHelper.BEFORE_1_8);
        ItemStackRemapper.registerClientboundRemapper(Material.BOOK_AND_QUILL, new EmptyBookPageAdderSpecificRemapper(), ProtocolVersionsHelper.ALL);
        EnchantFilterNBTSpecificRemapper enchantfilter = new EnchantFilterNBTSpecificRemapper();
        Arrays.stream(Material.values()).forEach(material -> ItemStackRemapper.registerClientboundRemapper(material, enchantfilter, ProtocolVersionsHelper.ALL));
        dragonHeadGameProfile = new GameProfile(UUIDTypeAdapter.fromString("d34aa2b831da4d269655e33c143f096c"), "EnderDragon");
        dragonHeadGameProfile.getProperties().put("textures", new PlayerPropertiesResolveEvent.ProfileProperty("textures", "eyJ0aW1lc3RhbXAiOjE0NzE0Mzg3NTEzMjYsInByb2ZpbGVJZCI6ImQzNGFhMmI4MzFkYTRkMjY5NjU1ZTMzYzE0M2YwOTZjIiwicHJvZmlsZU5hbWUiOiJFbmRlckRyYWdvbiIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWRlYzdhNGRlMDdiN2VkZWFjZTliOWI5OTY2NDRlMjFkNThjYmRhYzM5MmViZWIyNDdhY2NkMTg1MzRiNTQifX19", "I/XY6is7j0RTGFwuVhc4PVuWUl5RRNToNUpw6jCF+V4TzXYzsBreiLQ6IM4NSJqlPXBmSlqibblDKVQL/4LnXt24/nRNVzChZv68HXB1quGxmYcSEvOLpoUk1cmXgqWJYHA68C+r1ytoJVerGWuIwuBzQZ9GpH0yb+qg7erFQgB24cbH6hh6uB6KYLwIYLQAg3TFjILv9sVJtC3FakXmtkCV3VfRUdjhigpfKP0JR3VhLVIWeW/7E+C4QCXnGlffc3Lz8PNahXtD4qRitVokId0t1qBcL8mM1qnZ/rHlNPLST61ycY9WNlRr6P83yDw2ha8QMiRH1vI5tvdXIwV7Dkn+JxfhOOeHtGunLBVe7ZEWBZfjePr/HqZGR6F7/cwZU32uH5MdTXQ+oKWUlb6HJOXxj7DfMr/uZWjrwjzmKpSDAinwvQM/8Sf96prufvcSfhZ0yopkumpnTjivgPxsJhwFXThIyFZ3ijTClMgm5NSzmB6hJ+HsBnVkDs7eyE5eI72/ES/6SksFezmBzDOqU31QbPA2mWoOYWdyZngtnf45oFnZ7NNpDW7ZKxY7FTsPEXoON/VX516KbnQ5OERI9YUpGzyKCjyMnf0L99gwgHpx5LpawdzIwk04sqFoy796BkGJf7xH6+h+AurMIenMt4on7T4FUE1ZaJvvaqexQME="));
    }
}

