/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.version.v_legacy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.LegacyServerPingResponseEvent;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.netty.Allocator;

@ChannelHandler.Sharable
public class LegacyLoginAndPingHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf input) {
        ProtocolSupportPacketDataSerializer serializer = new ProtocolSupportPacketDataSerializer(Allocator.allocateBuffer(), ProtocolVersion.MINECRAFT_LEGACY);
        try {
            short packetId = input.readUnsignedByte();
            if (packetId == 254) {
                LegacyLoginAndPingHandler.writePing(ctx.channel(), serializer);
            } else if (packetId == 2) {
                LegacyLoginAndPingHandler.writeLoginKick(serializer);
            } else {
                throw new DecoderException("Unknown packet id " + packetId + " in legacy login and ping handler");
            }
            ctx.channel().pipeline().firstContext().writeAndFlush((Object)serializer).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            serializer = null;
        }
        finally {
            if (serializer != null) {
                serializer.release();
            }
        }
    }

    private static void writeLoginKick(ProtocolSupportPacketDataSerializer serializer) {
        serializer.writeByte(255);
        serializer.writeString("Outdated client");
    }

    private static void writePing(Channel channel, ProtocolSupportPacketDataSerializer serializer) {
        ConnectionImpl connection = ConnectionImpl.getFromChannel(channel);
        ServerListPingEvent bevent = new ServerListPingEvent(((Connection)connection).getAddress().getAddress(), Bukkit.getMotd(), Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers()){

            public void setServerIcon(CachedServerIcon icon) {
            }

            public Iterator<Player> iterator() {
                return Collections.emptyIterator();
            }
        };
        Bukkit.getPluginManager().callEvent((Event)bevent);
        LegacyServerPingResponseEvent revent = new LegacyServerPingResponseEvent(connection, bevent.getMotd(), bevent.getMaxPlayers());
        Bukkit.getPluginManager().callEvent((Event)revent);
        String response = ChatColor.stripColor((String)revent.getMotd()) + "\u00a7" + bevent.getNumPlayers() + "\u00a7" + revent.getMaxPlayers();
        serializer.writeByte(255);
        serializer.writeString(response);
    }
}

