/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.chat;

import org.bukkit.entity.Player;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.chat.modifiers.ClickAction;
import protocolsupport.api.chat.modifiers.HoverAction;
import protocolsupport.api.chat.modifiers.Modifier;
import protocolsupport.libs.com.google.gson.Gson;
import protocolsupport.libs.com.google.gson.GsonBuilder;
import protocolsupport.libs.org.apache.commons.lang3.Validate;
import protocolsupport.utils.chat.ClickActionSerializer;
import protocolsupport.utils.chat.ComponentSerializer;
import protocolsupport.utils.chat.HoverActionSerializer;
import protocolsupport.utils.chat.ModifierSerializer;
import protocolsupport.zplatform.ServerPlatform;

public class ChatAPI {
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(BaseComponent.class, new ComponentSerializer()).registerTypeHierarchyAdapter(Modifier.class, new ModifierSerializer()).registerTypeHierarchyAdapter(ClickAction.class, new ClickActionSerializer()).registerTypeHierarchyAdapter(HoverAction.class, new HoverActionSerializer()).create();

    public static BaseComponent fromJSON(String json) {
        return json != null ? gson.fromJson(json, BaseComponent.class) : null;
    }

    public static String toJSON(BaseComponent component) {
        return component != null ? gson.toJson(component) : null;
    }

    public static void sendMessage(Player player, BaseComponent message) {
        ChatAPI.sendMessage(player, message, MessagePosition.CHAT);
    }

    public static void sendMessage(Player player, String messageJson) {
        ChatAPI.sendMessage(player, messageJson, MessagePosition.CHAT);
    }

    public static void sendMessage(Player player, BaseComponent message, MessagePosition position) {
        ChatAPI.sendMessage(player, ChatAPI.toJSON(message), position);
    }

    public static void sendMessage(Player player, String messageJson, MessagePosition position) {
        Validate.notNull(player, "Player can't be null", new Object[0]);
        Validate.notNull(messageJson, "Message can't be null", new Object[0]);
        Validate.notNull(position, "Message position can't be null", new Object[0]);
        ProtocolSupportAPI.getConnection(player).sendPacket(ServerPlatform.get().getPacketFactory().createOutboundChatPacket(messageJson, position.ordinal()));
    }

    public static enum MessagePosition {
        CHAT,
        SYSMESSAGE,
        HOTBAR;

    }
}

