/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.logs;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.logs.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;

public class LogManager {
    private final List<Log> log = new ArrayList<Log>();

    public void startSavingScheduler() {
        Bukkit.getScheduler().runTaskTimer(Legendchat.getPlugin(), new Runnable(){

            @Override
            public void run() {
                LogManager.this.saveLog();
            }
        }, (long)(Legendchat.getLogToFileTime() * 1200), (long)(Legendchat.getLogToFileTime() * 1200));
    }

    public void addLogToCache(Log l) {
        if (!this.log.contains(l)) {
            this.log.add(l);
        }
    }

    public void addLogToCache(Date d, String m) {
        this.log.add(new Log(d, m));
    }

    public void addLogToCache(String m) {
        this.log.add(new Log(new Date(), m));
    }

    public void removeLogFromCache(Log l) {
        if (this.log.contains(l)) {
            this.log.remove(l);
        }
    }

    public List<Log> getLogCache() {
        ArrayList<Log> log2 = new ArrayList<Log>();
        log2.addAll(this.log);
        return log2;
    }

    public void saveLog() {
        List<Log> saving_log = this.getLogCache();
        if (saving_log.isEmpty()) {
            return;
        }
        this.log.clear();
        new Executor(saving_log).start();
    }

    private String getFileName(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(d) + ".txt";
    }

    private String formatLine(Date d, String l) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "[" + df.format(d) + "] " + l;
    }

    private class Executor
    extends Thread {
        private List<Log> saving_log = null;

        public Executor(List<Log> l) {
            this.saving_log = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File f2 = new File(Legendchat.getPlugin().getDataFolder(), "logs");
            if (!f2.exists()) {
                f2.mkdir();
            }
            HashMap date_log = new HashMap();
            for (Log l : this.saving_log) {
                String n = LogManager.this.getFileName(l.getDate());
                File f = new File(Legendchat.getPlugin().getDataFolder() + File.separator + "logs", n);
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (date_log.containsKey(n)) {
                    ((List)date_log.get(n)).add(l);
                    continue;
                }
                ArrayList<Log> ll = new ArrayList<Log>();
                ll.add(l);
                date_log.put(n, ll);
            }
            for (String n : date_log.keySet()) {
                File f = new File(Legendchat.getPlugin().getDataFolder() + File.separator + "logs", n);
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(f, true));
                    for (Log l : (List)date_log.get(n)) {
                        writer.write(LogManager.this.formatLine(l.getDate(), l.getMessage()));
                        writer.newLine();
                    }
                }
                catch (Exception e) {}
                continue;
                finally {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

