/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.ignore;

import br.com.devpaulo.legendchat.channels.types.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;

public class IgnoreManager {
    private final HashMap<Player, List<String>> ignoreList = new HashMap();
    private final HashMap<Player, List<Channel>> ignoreList2 = new HashMap();

    public void playerIgnorePlayer(Player who, String ignored) {
        if (this.hasPlayerIgnoredPlayer(who, ignored)) {
            return;
        }
        ArrayList<String> ignorados = new ArrayList<String>();
        if (this.playerHasIgnoredPlayersList(who)) {
            ignorados.addAll((Collection)this.ignoreList.get(who));
            this.ignoreList.remove(who);
        }
        ignorados.add(ignored.toLowerCase());
        this.ignoreList.put(who, ignorados);
    }

    public void playerUnignorePlayer(Player who, String ignored) {
        if (!this.hasPlayerIgnoredPlayer(who, ignored)) {
            return;
        }
        List<String> ignorados = this.ignoreList.get(who);
        ignorados.remove(ignored.toLowerCase());
        this.ignoreList.remove(who);
        if (ignorados.size() > 0) {
            this.ignoreList.put(who, ignorados);
        }
    }

    public boolean hasPlayerIgnoredPlayer(Player who, String ignored) {
        if (this.playerHasIgnoredPlayersList(who)) {
            return this.ignoreList.get(who).contains(ignored.toLowerCase());
        }
        return false;
    }

    public void playerIgnoreChannel(Player who, Channel ignored) {
        if (this.hasPlayerIgnoredChannel(who, ignored)) {
            return;
        }
        ArrayList<Channel> ignorados = new ArrayList<Channel>();
        if (this.playerHasIgnoredChannelsList(who)) {
            ignorados.addAll((Collection)this.ignoreList2.get(who));
            this.ignoreList2.remove(who);
        }
        ignorados.add(ignored);
        this.ignoreList2.put(who, ignorados);
    }

    public void playerUnignoreChannel(Player who, Channel c) {
        if (!this.hasPlayerIgnoredChannel(who, c)) {
            return;
        }
        List<Channel> ignorados = this.ignoreList2.get(who);
        ignorados.remove(c);
        this.ignoreList2.remove(who);
        if (ignorados.size() > 0) {
            this.ignoreList2.put(who, ignorados);
        }
    }

    public boolean hasPlayerIgnoredChannel(Player who, Channel ignored) {
        if (this.playerHasIgnoredChannelsList(who)) {
            return this.ignoreList2.get(who).contains(ignored);
        }
        return false;
    }

    public void playerDisconnect(Player p) {
        if (this.playerHasIgnoredPlayersList(p)) {
            this.ignoreList.remove(p);
        }
        if (this.playerHasIgnoredChannelsList(p)) {
            this.ignoreList2.remove(p);
        }
    }

    public boolean playerHasIgnoredPlayersList(Player p) {
        return this.ignoreList.containsKey(p);
    }

    public List<String> getPlayerIgnoredPlayersList(Player p) {
        if (this.playerHasIgnoredPlayersList(p)) {
            return this.ignoreList.get(p);
        }
        return null;
    }

    public boolean playerHasIgnoredChannelsList(Player p) {
        return this.ignoreList2.containsKey(p);
    }

    public List<Channel> getPlayerIgnoredChannelsList(Player p) {
        if (this.playerHasIgnoredChannelsList(p)) {
            return this.ignoreList2.get(p);
        }
        return null;
    }
}

