/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.commands;

import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.config.Message;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CommandSeen
extends Command {
    public CommandSeen(Marriage marriage) {
        super(marriage, "seen", new String[0]);
        this.setDescription(Message.COMMAND_SEEN.toString());
    }

    @Override
    public void execute() {
        MPlayer mPlayer = this.marriage.getMPlayer(this.player.getUniqueId());
        MData marriage = mPlayer.getMarriage();
        if (marriage == null) {
            this.reply(Message.NOT_MARRIED, new Object[0]);
            return;
        }
        MPlayer mp = this.marriage.getMPlayer(marriage.getOtherPlayer(this.player.getUniqueId()));
        Player partner = Bukkit.getPlayer((UUID)marriage.getOtherPlayer(this.player.getUniqueId()));
        if (partner != null) {
            long time = System.currentTimeMillis() - mp.getLastLogin();
            this.reply(Message.ONLINE_SINCE, this.format(time));
        } else {
            long time = System.currentTimeMillis() - mp.getLastLogout();
            ((MarriageCore)this.marriage).unloadPlayer(marriage.getOtherPlayer(this.player.getUniqueId()));
            this.reply(Message.OFFLINE_SINCE, this.format(time));
        }
    }

    private String format(long ms) {
        long sec = TimeUnit.MILLISECONDS.toSeconds(ms) % 60L;
        long min = TimeUnit.MILLISECONDS.toMinutes(ms) % 60L;
        long hrs = TimeUnit.MILLISECONDS.toHours(ms) % 24L;
        long dys = TimeUnit.MILLISECONDS.toDays(ms);
        if (dys > 0L) {
            return String.format("%sdys%shrs", dys, hrs);
        }
        if (hrs > 0L) {
            return String.format("%shrs%smin", hrs, min);
        }
        if (min > 0L) {
            return String.format("%smin%ssec", min, sec);
        }
        return sec + "sec";
    }
}

