/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.landManagement;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LandManagerView
implements Listener {
    private Player player;
    private Inventory ui;
    private LowOwnedLand mLand;
    private String[][] perms;
    private ArrayList<ItemStack[]> permCols = new ArrayList();
    private ArrayList<Integer> permSlots = new ArrayList();
    private int pageNum = 0;
    private boolean isOpen = true;
    private int numPages;

    public LandManagerView(Player player, LowOwnedLand mLand) {
        Landlord.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Landlord.getInstance());
        this.player = player;
        this.mLand = mLand;
        this.perms = mLand.getLandPerms(true);
        this.ui = Bukkit.createInventory(null, (int)36, (String)"Gestionnaire du terrain");
        this.updateUIData();
        this.numPages = (int)Math.ceil((double)this.permCols.size() / 8.0);
        if (this.numPages == 1) {
            this.ui = Bukkit.createInventory(null, (int)27, (String)"Gestionnaire du terrain");
        }
        this.setToggles();
        this.buildUI();
    }

    private ItemStack makeButton(String displayName, String[] lore, Material material) {
        return this.makeButton(displayName, lore, new ItemStack(material));
    }

    private ItemStack makeButton(String displayName, String[] lore, ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(displayName);
        meta.setLore(Arrays.asList(lore));
        stack.setItemMeta(meta);
        return stack;
    }

    public void showUI() {
        this.player.openInventory(this.ui);
    }

    private void updateUIData() {
        this.permSlots.clear();
        this.permCols.clear();
        for (Map.Entry<String, Landflag> entry : Landlord.getInstance().getFlagManager().getRegisteredFlags().entrySet()) {
            ItemStack friendState;
            ItemStack allState;
            Landflag l = entry.getValue();
            this.permSlots.add(new Integer(l.getPermSlot()));
            String[] loreData = l.getDescription().split("\\|");
            String[] desc = this.colorLore(loreData);
            ItemStack header = this.makeButton(ChatColor.YELLOW + l.getDisplayName(), desc, l.getHeaderItem());
            if (this.perms[0][l.getPermSlot()].equals("1")) {
                desc = this.colorLore(("Les joueurs normaux " + l.getAllowedText() + "|" + ChatColor.YELLOW + "Cliquez pour modifier.").split("\\|"));
                allState = this.makeButton(ChatColor.GREEN + l.getAllowedTitle(), desc, new ItemStack(Material.WOOL, 1, 5));
            } else {
                desc = this.colorLore(("Les joueurs normaux " + l.getDeniedText() + "|" + ChatColor.YELLOW + "Cliquez pour modifier.").split("\\|"));
                allState = this.makeButton(ChatColor.RED + l.getDeniedTitle(), desc, new ItemStack(Material.WOOL, 1, 14));
            }
            if (this.perms[1][l.getPermSlot()].equals("1")) {
                desc = this.colorLore(("Les friends du terrain " + l.getAllowedText() + "|" + ChatColor.YELLOW + "Cliquez pour modifier.").split("\\|"));
                friendState = this.makeButton(ChatColor.GREEN + l.getAllowedTitle(), desc, new ItemStack(Material.WOOL, 1, 5));
            } else {
                desc = this.colorLore(("Les amis du terrain " + l.getDeniedText() + "|" + ChatColor.YELLOW + "Cliquez pour modifier.").split("\\|"));
                friendState = this.makeButton(ChatColor.RED + l.getDeniedTitle(), desc, new ItemStack(Material.WOOL, 1, 14));
            }
            this.permCols.add(new ItemStack[]{header, allState, friendState});
        }
    }

    private String[] colorLore(String[] loreData) {
        String[] desc = new String[loreData.length];
        int s = 0;
        while (s < loreData.length) {
            desc[s] = ChatColor.RESET + loreData[s];
            ++s;
        }
        return desc;
    }

    private void buildUI() {
        this.ui.setItem(0, this.makeButton(ChatColor.GOLD + "Aide", new String[]{ChatColor.RESET + "Cliquez sur les blocs de laine", ChatColor.RESET + "pour modifier la permission d'un groupe.", ChatColor.RESET + "Les laines rouges traduisent une interdiction", ChatColor.RESET + "et les laines vertes traduisent une autorisation.", ChatColor.RESET + "Passez votre souris sur chaque item pour avoir plus d'informations."}, Material.ENCHANTED_BOOK));
        this.ui.setItem(9, this.makeButton(ChatColor.YELLOW + "Tout le monde", new String[]{ChatColor.RESET + "Les permissions de cette rang\u00e9e s'appliquent", ChatColor.RESET + "aux joueurs qui ne sont pas des friends", ChatColor.RESET + "de ce terrain."}, new ItemStack(Material.SKULL_ITEM, 1, 2)));
        this.ui.setItem(18, this.makeButton(ChatColor.YELLOW + "Friends", new String[]{ChatColor.RESET + "Les permissions de cette rang\u00e9e s'appliquent", ChatColor.RESET + "aux friends de ce terrain."}, new ItemStack(Material.SKULL_ITEM, 1, 3)));
        if (this.pageNum < this.numPages - 1) {
            this.ui.setItem(35, this.makeButton(ChatColor.YELLOW + "Page suivante", new String[]{ChatColor.RESET + "Regarder les options de la page suivante."}, new ItemStack(Material.PAPER)));
        }
        if (this.pageNum > 0) {
            this.ui.setItem(27, this.makeButton(ChatColor.YELLOW + "Page pr\u00e9c\u00e9dente", new String[]{ChatColor.RESET + "Regarder les options de la page pr\u00e9c\u00e9dente."}, new ItemStack(Material.PAPER)));
        }
    }

    private void setToggles() {
        int startIndex = this.pageNum * 8;
        this.ui.clear();
        int endIndex = this.pageNum == this.numPages - 1 ? this.permCols.size() : startIndex + 8;
        int slot = 1;
        int i = startIndex;
        while (i < endIndex) {
            this.ui.setItem(slot, this.permCols.get(i)[0]);
            this.ui.setItem(slot + 9, this.permCols.get(i)[1]);
            this.ui.setItem(slot + 18, this.permCols.get(i)[2]);
            ++slot;
            ++i;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity p = event.getPlayer();
        if (event.getInventory().getTitle().contains("Gestionnaire du terrain") && p.getName().equalsIgnoreCase(this.player.getName()) && this.isOpen) {
            this.mLand.setPermissions(this.mLand.permsToString(this.perms));
            this.mLand.save();
            this.player.sendMessage(ChatColor.GREEN + "Les permissions du terrain ont \u00e9t\u00e9 sauvegard\u00e9es!");
            if (Landlord.getInstance().getConfig().getBoolean("options.soundEffects", true)) {
                this.player.playSound(this.player.getLocation(), Sound.FIZZ, 10.0f, 10.0f);
            }
            this.mLand.highlightLand(this.player, Effect.LAVADRIP);
            Landlord.getInstance().getManageViewManager().NoCloseDeactivateView(this.player);
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void clickButton(InventoryClickEvent event) {
        if (event.getInventory().getTitle().contains("Gestionnaire du terrain") && event.getWhoClicked().getName().equalsIgnoreCase(this.player.getName())) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            int row = slot / 9;
            int col = slot % 9;
            int startIndex = this.pageNum * 8;
            int endIndex = this.pageNum == this.numPages - 1 ? this.permCols.size() : startIndex + 8;
            if (col <= endIndex - startIndex && col > 0) {
                if (row == 1) {
                    this.player.playSound(this.player.getLocation(), Sound.CLICK, 1.0f, 1.0f);
                    this.perms[0][this.permSlots.get((int)(col - 1 + this.pageNum * 8)).intValue()] = this.bSwap(this.perms[0][this.permSlots.get(col - 1 + this.pageNum * 8)]);
                } else if (row == 2) {
                    this.player.playSound(this.player.getLocation(), Sound.CLICK, 1.0f, 1.0f);
                    this.perms[1][this.permSlots.get((int)(col - 1 + this.pageNum * 8)).intValue()] = this.bSwap(this.perms[1][this.permSlots.get(col - 1 + this.pageNum * 8)]);
                }
                this.updateUIData();
                this.setToggles();
                this.buildUI();
            }
            if (this.pageNum < this.numPages - 1 && event.getRawSlot() == 35) {
                this.player.playSound(this.player.getLocation(), Sound.CLICK, 1.0f, 1.0f);
                ++this.pageNum;
                this.updateUIData();
                this.setToggles();
                this.buildUI();
            }
            if (this.pageNum > 0 && event.getRawSlot() == 27) {
                this.player.playSound(this.player.getLocation(), Sound.CLICK, 1.0f, 1.0f);
                --this.pageNum;
                this.updateUIData();
                this.setToggles();
                this.buildUI();
            }
        }
    }

    private String bSwap(String s) {
        if (s.equals("0")) {
            return "1";
        }
        return "0";
    }

    public void closeView() {
        this.player.closeInventory();
    }
}

