/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.landManagement;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.LandFlagPerm;
import java.util.HashMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FlagManager {
    HashMap<String, Landflag> registeredFlags = new HashMap();
    Landlord plugin;

    public FlagManager(Landlord plugin) {
        this.plugin = plugin;
    }

    public HashMap<String, Landflag> getRegisteredFlags() {
        return this.registeredFlags;
    }

    public boolean registerFlag(Landflag f) {
        if (this.registeredFlags.containsKey(f.getClass().getSimpleName())) {
            this.plugin.getLogger().warning("Le flag \"" + f.getClass().getSimpleName() + "\" n'est pas utilisable car un flag est d\u00e9j\u00e0 enregistr\u00e9 avec ce nom!");
            f.setUniqueName(f.getClass().getSimpleName());
            return false;
        }
        LandFlagPerm lfp = (LandFlagPerm)this.plugin.getDatabase().find(LandFlagPerm.class).where().eq("identifier", (Object)f.getClass().getSimpleName()).findUnique();
        if (lfp == null) {
            this.plugin.getLogger().info("Enregistrement d'un nouveau flag de terrain: " + f.getClass().getSimpleName());
            lfp = LandFlagPerm.flagPermFromData(f.getClass().getSimpleName(), this.plugin.getDatabase().find(LandFlagPerm.class).findRowCount() + 1);
            this.plugin.getDatabase().save((Object)lfp);
        }
        f.setPermSlot(lfp.getPermSlot());
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)f, (Plugin)this.plugin);
            this.registeredFlags.put(f.getClass().getSimpleName(), f);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Une erreur est survenue pendant l'enregistrement du flag \"" + f.getClass().getSimpleName() + "\":");
            e.printStackTrace();
            return false;
        }
        this.plugin.getLogger().info("Enregistrement du flag: " + f.getClass().getSimpleName());
        return true;
    }

    public int numStoredPerms() {
        return this.plugin.getDatabase().find(LandFlagPerm.class).findList().size();
    }
}

