/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.landFlags;

import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class TntDamage
extends Landflag {
    public TntDamage() {
        super("Dommages de la TNT", "Donne la permission de casser|les blocs avec la TNT.", new ItemStack(Material.TNT), "Autorise les dommages de la TNT", "peuvent faire des dommages avec de la TNT.", "Interdit les dommages de la TNT", "ne peuvent pas faire de dommages avec de la TNT.");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void tntExplode(EntityExplodeEvent event) {
        if (event.getEntityType() == null) {
            return;
        }
        if (!event.getEntityType().equals((Object)EntityType.PRIMED_TNT)) {
            return;
        }
        TNTPrimed tnt = (TNTPrimed)event.getEntity();
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getLocation());
        if (land != null) {
            if (tnt.getSource() != null && tnt.getSource().getType().equals((Object)EntityType.PLAYER)) {
                Player p = (Player)tnt.getSource();
                if (!land.hasPermTo(p, this)) {
                    p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire exploser de TNT sur ce terrain.");
                    event.setCancelled(true);
                    return;
                }
            } else if (!land.canEveryone(this)) {
                event.setCancelled(true);
                return;
            }
        }
        List destroyed = event.blockList();
        Iterator it = destroyed.iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            LowOwnedLand lnd = LowOwnedLand.getApplicableLand(block.getLocation());
            if (lnd == null || lnd.canEveryone(this) || tnt.getSource() instanceof Player && lnd.hasPermTo((Player)tnt.getSource(), this)) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void tntMinecartExplode(EntityExplodeEvent event) {
        if (event.getEntityType() == null) {
            return;
        }
        if (!event.getEntityType().equals((Object)EntityType.MINECART_TNT)) {
            return;
        }
        LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getLocation());
        if (land != null && !land.canEveryone(this)) {
            event.setCancelled(true);
            return;
        }
        List destroyed = event.blockList();
        Iterator it = destroyed.iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            LowOwnedLand lnd = LowOwnedLand.getApplicableLand(block.getLocation());
            if (lnd == null || lnd.canEveryone(this)) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void igniteTnt(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getClickedBlock().getType().equals((Object)Material.TNT) && event.getItem() != null && event.getItem().getType().equals((Object)Material.FLINT_AND_STEEL)) {
            LowOwnedLand land = LowOwnedLand.getApplicableLand(event.getClickedBlock().getLocation());
            if (land == null) {
                return;
            }
            Player p = event.getPlayer();
            if (!land.hasPermTo(p, this)) {
                p.sendMessage(ChatColor.RED + "Vous ne pouvez pas faire exploser de TNT sur ce terrain.");
                event.setCancelled(true);
            }
        }
    }
}

